/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.google.protobuf.ByteString;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.CastChannel;
import org.digitalmediaserver.cast.Util;

@Immutable
public abstract class ImmutableCastMessage {
    @Nonnull
    protected final String destinationId;
    @Nonnull
    protected final String namespace;
    @Nonnull
    protected final CastChannel.CastMessage.ProtocolVersion protocolVersion;
    @Nonnull
    protected final String sourceId;

    protected ImmutableCastMessage(@Nonnull String destinationId, @Nonnull String namespace, @Nonnull CastChannel.CastMessage.ProtocolVersion protocolVersion, @Nonnull String sourceId) {
        Util.requireNotNull(destinationId, "destinationId");
        Util.requireNotNull(namespace, "namespace");
        Util.requireNotNull((Object)protocolVersion, "protocolVersion");
        Util.requireNotNull(sourceId, "sourceId");
        this.destinationId = destinationId;
        this.namespace = namespace;
        this.protocolVersion = protocolVersion;
        this.sourceId = sourceId;
    }

    @Nonnull
    public String getDestinationId() {
        return this.destinationId;
    }

    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    @Nonnull
    public CastChannel.CastMessage.ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Nonnull
    public String getSourceId() {
        return this.sourceId;
    }

    @Nonnull
    public static ImmutableCastMessage create(@Nonnull CastChannel.CastMessage message) {
        Util.requireNotNull(message, "message");
        if (message.getPayloadType() == CastChannel.CastMessage.PayloadType.STRING) {
            return new ImmutableStringCastMessage(message.getDestinationId(), message.getNamespace(), message.getPayloadUtf8(), message.getProtocolVersion(), message.getSourceId());
        }
        return new ImmutableBinaryCastMessage(message.getDestinationId(), message.getNamespace(), message.getPayloadBinary(), message.getProtocolVersion(), message.getSourceId());
    }

    public static class ImmutableBinaryCastMessage
    extends ImmutableCastMessage {
        @Nonnull
        protected final ByteString payload;

        public ImmutableBinaryCastMessage(@Nonnull String destinationId, @Nonnull String namespace, @Nonnull ByteString payload, @Nonnull CastChannel.CastMessage.ProtocolVersion protocolVersion, @Nonnull String sourceId) {
            super(destinationId, namespace, protocolVersion, sourceId);
            Util.requireNotNull(payload, "payload");
            this.payload = payload;
        }

        @Nonnull
        public ByteString getPayload() {
            return this.payload;
        }
    }

    public static class ImmutableStringCastMessage
    extends ImmutableCastMessage {
        @Nonnull
        protected final String payload;

        public ImmutableStringCastMessage(@Nonnull String destinationId, @Nonnull String namespace, @Nonnull String payload, @Nonnull CastChannel.CastMessage.ProtocolVersion protocolVersion, @Nonnull String sourceId) {
            super(destinationId, namespace, protocolVersion, sourceId);
            Util.requireNotNull(payload, "payload");
            this.payload = payload;
        }

        @Nonnull
        public String getPayload() {
            return this.payload;
        }
    }
}

