/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LiveSeekableRange {
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Double start;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Double end;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Boolean isLiveDone;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Boolean isMovingWindow;

    public LiveSeekableRange(@JsonProperty(value="start") Double start, @JsonProperty(value="end") Double end, @JsonProperty(value="isLiveDone") Boolean isLiveDone, @JsonProperty(value="isMovingWindow") Boolean isMovingWindow) {
        this.start = start;
        this.end = end;
        this.isLiveDone = isLiveDone;
        this.isMovingWindow = isMovingWindow;
    }

    @Nullable
    public Double getStart() {
        return this.start;
    }

    @Nullable
    public Double getEnd() {
        return this.end;
    }

    @Nullable
    public Boolean getIsLiveDone() {
        return this.isLiveDone;
    }

    @Nullable
    public Boolean getIsMovingWindow() {
        return this.isMovingWindow;
    }

    public int hashCode() {
        return Objects.hash(this.end, this.isLiveDone, this.isMovingWindow, this.start);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiveSeekableRange)) {
            return false;
        }
        LiveSeekableRange other = (LiveSeekableRange)obj;
        return Objects.equals(this.end, other.end) && Objects.equals(this.isLiveDone, other.isLiveDone) && Objects.equals(this.isMovingWindow, other.isMovingWindow) && Objects.equals(this.start, other.start);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        if (this.start != null) {
            builder.append("start=").append(this.start).append(", ");
        }
        if (this.end != null) {
            builder.append("end=").append(this.end).append(", ");
        }
        if (this.isLiveDone != null) {
            builder.append("isLiveDone=").append(this.isLiveDone).append(", ");
        }
        if (this.isMovingWindow != null) {
            builder.append("isMovingWindow=").append(this.isMovingWindow);
        }
        builder.append("]");
        return builder.toString();
    }
}

