/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.Util;

@Immutable
public class LoadOptions {
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final ContentFilteringMode contentFilteringMode;

    public LoadOptions(@JsonProperty(value="contentFilteringMode") @Nullable ContentFilteringMode contentFilteringMode) {
        this.contentFilteringMode = contentFilteringMode;
    }

    @Nullable
    public ContentFilteringMode getContentFilteringMode() {
        return this.contentFilteringMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentFilteringMode});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LoadOptions)) {
            return false;
        }
        LoadOptions other = (LoadOptions)obj;
        return Objects.equals((Object)this.contentFilteringMode, (Object)other.contentFilteringMode);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [contentFilteringMode=" + (Object)((Object)this.contentFilteringMode) + "]";
    }

    public static enum ContentFilteringMode {
        FILTER_EXPLICIT;


        @Nullable
        @JsonCreator
        public static ContentFilteringMode typeOf(String contentFilteringMode) {
            if (Util.isBlank(contentFilteringMode)) {
                return null;
            }
            String typeString = contentFilteringMode.toUpperCase(Locale.ROOT);
            for (ContentFilteringMode type : ContentFilteringMode.values()) {
                if (!typeString.equals(type.name())) continue;
                return type;
            }
            return null;
        }
    }
}

