/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.Image;
import org.digitalmediaserver.cast.Metadata;
import org.digitalmediaserver.cast.TextTrackStyle;
import org.digitalmediaserver.cast.Track;
import org.digitalmediaserver.cast.Util;

@Immutable
public class Media {
    @Nonnull
    @JsonProperty
    protected final String contentId;
    @Nonnull
    @JsonProperty
    protected final String contentType;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String contentUrl;
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final Map<String, Object> customData;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Double duration;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String entity;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final HlsSegmentFormat hlsSegmentFormat;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final HlsVideoSegmentFormat hlsVideoSegmentFormat;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final MediaCategory mediaCategory;
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final Map<String, Object> metadata;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Long startAbsoluteTime;
    @Nonnull
    @JsonProperty
    protected final StreamType streamType;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final TextTrackStyle textTrackStyle;
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final List<Track> tracks;

    public Media(@JsonProperty(value="contentId") String contentId, @JsonProperty(value="contentType") String contentType, @JsonProperty(value="contentUrl") String contentUrl, @JsonProperty(value="customData") Map<String, Object> customData, @JsonProperty(value="duration") Double duration, @JsonProperty(value="entity") String entity, @JsonProperty(value="hlsSegmentFormat") HlsSegmentFormat hlsSegmentFormat, @JsonProperty(value="hlsVideoSegmentFormat") HlsVideoSegmentFormat hlsVideoSegmentFormat, @JsonProperty(value="mediaCategory") MediaCategory mediaCategory, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="startAbsoluteTime") Long startAbsoluteTime, @JsonProperty(value="streamType") StreamType streamType, @JsonProperty(value="textTrackStyle") TextTrackStyle textTrackStyle, @JsonProperty(value="tracks") List<Track> tracks) {
        this.contentId = contentId;
        this.contentType = contentType;
        this.contentUrl = contentUrl;
        this.duration = duration;
        this.entity = entity;
        this.hlsSegmentFormat = hlsSegmentFormat;
        this.hlsVideoSegmentFormat = hlsVideoSegmentFormat;
        this.mediaCategory = mediaCategory;
        this.metadata = metadata == null || metadata.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(metadata));
        this.startAbsoluteTime = startAbsoluteTime;
        this.streamType = streamType;
        this.customData = customData == null || customData.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(customData));
        this.textTrackStyle = textTrackStyle;
        this.tracks = tracks == null || tracks.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Track>(tracks));
    }

    @Nonnull
    public String getContentId() {
        return this.contentId;
    }

    @Nonnull
    public String getContentType() {
        return this.contentType;
    }

    @Nullable
    public String getContentUrl() {
        return this.contentUrl;
    }

    @Nullable
    @JsonIgnore
    public String getUrl() {
        return Util.isBlank(this.contentUrl) ? this.contentId : this.contentUrl;
    }

    @Nonnull
    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    @Nullable
    public Double getDuration() {
        return this.duration;
    }

    @Nullable
    public String getEntity() {
        return this.entity;
    }

    @Nullable
    public HlsSegmentFormat getHlsSegmentFormat() {
        return this.hlsSegmentFormat;
    }

    @Nullable
    public HlsVideoSegmentFormat getHlsVideoSegmentFormat() {
        return this.hlsVideoSegmentFormat;
    }

    @Nullable
    public MediaCategory getMediaCategory() {
        return this.mediaCategory;
    }

    @Nonnull
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    @Nonnull
    public List<Image> getImages() {
        return Metadata.extractImages(this.metadata);
    }

    @Nullable
    public Long getStartAbsoluteTime() {
        return this.startAbsoluteTime;
    }

    @Nonnull
    public StreamType getStreamType() {
        return this.streamType;
    }

    @Nullable
    public TextTrackStyle getTextTrackStyle() {
        return this.textTrackStyle;
    }

    @Nonnull
    public List<Track> getTracks() {
        return this.tracks;
    }

    @Nullable
    @JsonIgnore
    public Metadata.MetadataType getMetadataType() {
        Object object = this.metadata.get("metadataType");
        if (object instanceof Integer) {
            return Metadata.MetadataType.typeOf((Integer)object);
        }
        return null;
    }

    @Nonnull
    @JsonIgnore
    public MediaBuilder modify() {
        return new MediaBuilder(this.contentId, this.contentType, this.contentUrl, new LinkedHashMap<String, Object>(this.customData), this.duration, this.entity, this.hlsSegmentFormat, this.hlsVideoSegmentFormat, this.mediaCategory, new LinkedHashMap<String, Object>(this.metadata), this.startAbsoluteTime, this.streamType, this.textTrackStyle, new ArrayList<Track>(this.tracks));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentId, this.contentType, this.contentUrl, this.customData, this.duration, this.entity, this.hlsSegmentFormat, this.hlsVideoSegmentFormat, this.mediaCategory, this.metadata, this.startAbsoluteTime, this.streamType, this.textTrackStyle, this.tracks});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Media)) {
            return false;
        }
        Media other = (Media)obj;
        return Objects.equals(this.contentId, other.contentId) && Objects.equals(this.contentType, other.contentType) && Objects.equals(this.contentUrl, other.contentUrl) && Objects.equals(this.customData, other.customData) && Objects.equals(this.duration, other.duration) && Objects.equals(this.entity, other.entity) && this.hlsSegmentFormat == other.hlsSegmentFormat && this.hlsVideoSegmentFormat == other.hlsVideoSegmentFormat && this.mediaCategory == other.mediaCategory && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.startAbsoluteTime, other.startAbsoluteTime) && this.streamType == other.streamType && Objects.equals(this.textTrackStyle, other.textTrackStyle) && Objects.equals(this.tracks, other.tracks);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        if (this.contentId != null) {
            builder.append("contentId=").append(this.contentId).append(", ");
        }
        if (this.contentType != null) {
            builder.append("contentType=").append(this.contentType).append(", ");
        }
        if (this.contentUrl != null) {
            builder.append("contentUrl=").append(this.contentUrl).append(", ");
        }
        if (this.customData != null) {
            builder.append("customData=").append(this.customData).append(", ");
        }
        if (this.duration != null) {
            builder.append("duration=").append(this.duration).append(", ");
        }
        if (this.entity != null) {
            builder.append("entity=").append(this.entity).append(", ");
        }
        if (this.hlsSegmentFormat != null) {
            builder.append("hlsSegmentFormat=").append((Object)this.hlsSegmentFormat).append(", ");
        }
        if (this.hlsVideoSegmentFormat != null) {
            builder.append("hlsVideoSegmentFormat=").append((Object)this.hlsVideoSegmentFormat).append(", ");
        }
        if (this.mediaCategory != null) {
            builder.append("mediaCategory=").append((Object)this.mediaCategory).append(", ");
        }
        if (this.metadata != null) {
            builder.append("metadata=").append(this.metadata).append(", ");
        }
        if (this.startAbsoluteTime != null) {
            builder.append("startAbsoluteTime=").append(this.startAbsoluteTime).append(", ");
        }
        if (this.streamType != null) {
            builder.append("streamType=").append((Object)this.streamType).append(", ");
        }
        if (this.textTrackStyle != null) {
            builder.append("textTrackStyle=").append(this.textTrackStyle).append(", ");
        }
        if (this.tracks != null) {
            builder.append("tracks=").append(this.tracks);
        }
        builder.append("]");
        return builder.toString();
    }

    public static MediaBuilder builder(@Nullable String contentUrl, @Nonnull String contentType, @Nonnull StreamType streamType) {
        return new MediaBuilder(contentUrl, contentType, streamType);
    }

    public static class MediaBuilder {
        @Nonnull
        protected String contentId;
        @Nonnull
        protected String contentType;
        @Nullable
        protected String contentUrl;
        @Nullable
        protected Map<String, Object> customData;
        @Nullable
        protected Double duration;
        @Nullable
        protected String entity;
        @Nullable
        protected HlsSegmentFormat hlsSegmentFormat;
        @Nullable
        protected HlsVideoSegmentFormat hlsVideoSegmentFormat;
        @Nullable
        protected MediaCategory mediaCategory;
        @Nullable
        protected Map<String, Object> metadata;
        @Nullable
        protected Long startAbsoluteTime;
        @Nonnull
        protected StreamType streamType;
        @Nullable
        protected TextTrackStyle textTrackStyle;
        @Nullable
        protected List<Track> tracks;

        public MediaBuilder(@Nullable String contentUrl, @Nonnull String contentType, @Nonnull StreamType streamType) {
            Util.requireNotBlank(contentType, "contentType");
            Util.requireNotNull((Object)streamType, "streamType");
            this.contentId = "";
            this.contentUrl = contentUrl;
            this.contentType = contentType;
            this.streamType = streamType;
        }

        protected MediaBuilder(@Nonnull String contentId, @Nonnull String contentType, @Nullable String contentUrl, @Nullable Map<String, Object> customData, @Nullable Double duration, @Nullable String entity, @Nullable HlsSegmentFormat hlsSegmentFormat, @Nullable HlsVideoSegmentFormat hlsVideoSegmentFormat, @Nullable MediaCategory mediaCategory, @Nullable Map<String, Object> metadata, @Nullable Long startAbsoluteTime, @Nonnull StreamType streamType, @Nullable TextTrackStyle textTrackStyle, @Nullable List<Track> tracks) {
            this.contentId = contentId;
            this.contentType = contentType;
            this.contentUrl = contentUrl;
            this.customData = customData;
            this.duration = duration;
            this.entity = entity;
            this.hlsSegmentFormat = hlsSegmentFormat;
            this.hlsVideoSegmentFormat = hlsVideoSegmentFormat;
            this.mediaCategory = mediaCategory;
            this.metadata = metadata;
            this.startAbsoluteTime = startAbsoluteTime;
            this.streamType = streamType;
            this.textTrackStyle = textTrackStyle;
            this.tracks = tracks;
        }

        @Nonnull
        public String contentId() {
            return this.contentId;
        }

        @Nonnull
        public MediaBuilder contentId(@Nonnull String contentId) {
            Util.requireNotNull(contentId, "contentId");
            this.contentId = contentId;
            return this;
        }

        @Nonnull
        public String contentType() {
            return this.contentType;
        }

        @Nonnull
        public MediaBuilder contentTypeId(@Nonnull String contentType) {
            Util.requireNotBlank(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        @Nullable
        public String contentUrl() {
            return this.contentUrl;
        }

        @Nonnull
        public MediaBuilder contentUrl(@Nullable String contentUrl) {
            this.contentUrl = contentUrl;
            return this;
        }

        @Nullable
        public Map<String, Object> customData() {
            return this.customData;
        }

        @Nonnull
        public MediaBuilder customData(@Nullable Map<String, Object> customData) {
            this.customData = customData;
            return this;
        }

        @Nullable
        public Double duration() {
            return this.duration;
        }

        @Nonnull
        public MediaBuilder duration(@Nullable Double duration) {
            this.duration = duration;
            return this;
        }

        @Nullable
        public String entity() {
            return this.entity;
        }

        @Nonnull
        public MediaBuilder entity(@Nullable String entity) {
            this.entity = entity;
            return this;
        }

        @Nullable
        public HlsSegmentFormat hlsSegmentFormat() {
            return this.hlsSegmentFormat;
        }

        @Nonnull
        public MediaBuilder hlsSegmentFormat(@Nullable HlsSegmentFormat hlsSegmentFormat) {
            this.hlsSegmentFormat = hlsSegmentFormat;
            return this;
        }

        @Nullable
        public HlsVideoSegmentFormat hlsVideoSegmentFormat() {
            return this.hlsVideoSegmentFormat;
        }

        @Nonnull
        public MediaBuilder hlsVideoSegmentFormat(@Nullable HlsVideoSegmentFormat hlsVideoSegmentFormat) {
            this.hlsVideoSegmentFormat = hlsVideoSegmentFormat;
            return this;
        }

        @Nullable
        public MediaCategory mediaCategory() {
            return this.mediaCategory;
        }

        @Nonnull
        public MediaBuilder mediaCategory(@Nullable MediaCategory mediaCategory) {
            this.mediaCategory = mediaCategory;
            return this;
        }

        @Nullable
        public Map<String, Object> metadata() {
            return this.metadata;
        }

        @Nonnull
        public MediaBuilder metadata(@Nullable Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Nullable
        public Long startAbsoluteTime() {
            return this.startAbsoluteTime;
        }

        @Nonnull
        public MediaBuilder startAbsoluteTime(@Nullable Long startAbsoluteTime) {
            this.startAbsoluteTime = startAbsoluteTime;
            return this;
        }

        @Nonnull
        public StreamType streamType() {
            return this.streamType;
        }

        @Nonnull
        public MediaBuilder streamType(@Nonnull StreamType streamType) {
            Util.requireNotNull((Object)streamType, "streamType");
            this.streamType = streamType;
            return this;
        }

        @Nullable
        public TextTrackStyle textTrackStyle() {
            return this.textTrackStyle;
        }

        @Nonnull
        public MediaBuilder textTrackStyle(@Nullable TextTrackStyle textTrackStyle) {
            this.textTrackStyle = textTrackStyle;
            return this;
        }

        @Nullable
        public List<Track> tracks() {
            return this.tracks;
        }

        @Nonnull
        public MediaBuilder addTrack(@Nullable Track track) {
            if (track != null) {
                if (this.tracks == null) {
                    this.tracks = new ArrayList<Track>();
                }
                this.tracks.add(track);
            }
            return this;
        }

        @Nonnull
        public MediaBuilder addTrack(int index, @Nullable Track track) {
            if (track != null) {
                if (this.tracks == null) {
                    this.tracks = new ArrayList<Track>();
                }
                this.tracks.add(index, track);
            }
            return this;
        }

        @Nonnull
        public MediaBuilder clearTracks() {
            if (this.tracks != null) {
                this.tracks.clear();
            }
            return this;
        }

        @Nonnull
        public MediaBuilder removeTrack(int index) {
            if (this.tracks != null) {
                this.tracks.remove(index);
            }
            return this;
        }

        @Nonnull
        public MediaBuilder removeTrack(@Nullable Track track) {
            if (track != null && this.tracks != null) {
                this.tracks.remove(track);
            }
            return this;
        }

        @Nonnull
        public MediaBuilder tracks(@Nullable List<Track> tracks) {
            this.tracks = tracks;
            return this;
        }

        @Nonnull
        public Media build() {
            return new Media(this.contentId, this.contentType, this.contentUrl, this.customData, this.duration, this.entity, this.hlsSegmentFormat, this.hlsVideoSegmentFormat, this.mediaCategory, this.metadata, this.startAbsoluteTime, this.streamType, this.textTrackStyle, this.tracks);
        }
    }

    public static enum StreamType {
        BUFFERED,
        LIVE,
        NONE;


        @Nullable
        @JsonCreator
        public static StreamType typeOf(String streamType) {
            if (Util.isBlank(streamType)) {
                return null;
            }
            String typeString = streamType.toUpperCase(Locale.ROOT);
            for (StreamType type : StreamType.values()) {
                if (!typeString.equals(type.name())) continue;
                return type;
            }
            return null;
        }
    }

    public static enum MediaCategory {
        AUDIO,
        VIDEO,
        IMAGE;


        @Nullable
        @JsonCreator
        public static MediaCategory typeOf(String mediaCategory) {
            if (Util.isBlank(mediaCategory)) {
                return null;
            }
            String typeString = mediaCategory.toUpperCase(Locale.ROOT);
            for (MediaCategory type : MediaCategory.values()) {
                if (!typeString.equals(type.name())) continue;
                return type;
            }
            return null;
        }
    }

    public static enum HlsVideoSegmentFormat {
        MPEG2_TS,
        FMP4;


        @Nullable
        @JsonCreator
        public static HlsVideoSegmentFormat typeOf(String hlsVideoSegmentFormat) {
            if (Util.isBlank(hlsVideoSegmentFormat)) {
                return null;
            }
            String typeString = hlsVideoSegmentFormat.toUpperCase(Locale.ROOT);
            for (HlsVideoSegmentFormat type : HlsVideoSegmentFormat.values()) {
                if (!typeString.equals(type.name())) continue;
                return type;
            }
            return null;
        }
    }

    public static enum HlsSegmentFormat {
        AAC,
        AC3,
        MP3,
        TS,
        TS_AAC,
        E_AC3,
        FMP4;


        @Nullable
        @JsonCreator
        public static HlsSegmentFormat typeOf(String hlsSegmentFormat) {
            if (Util.isBlank(hlsSegmentFormat)) {
                return null;
            }
            String typeString = hlsSegmentFormat.toUpperCase(Locale.ROOT);
            for (HlsSegmentFormat type : HlsSegmentFormat.values()) {
                if (!typeString.equals(type.name())) continue;
                return type;
            }
            return null;
        }
    }
}

