/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.ExtendedMediaStatus;
import org.digitalmediaserver.cast.LiveSeekableRange;
import org.digitalmediaserver.cast.Media;
import org.digitalmediaserver.cast.MediaVolume;
import org.digitalmediaserver.cast.QueueData;
import org.digitalmediaserver.cast.QueueItem;
import org.digitalmediaserver.cast.Util;
import org.digitalmediaserver.cast.VideoInformation;

@Immutable
public class MediaStatus {
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final List<Integer> activeTrackIds;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Integer currentItemId;
    @JsonProperty
    protected final double currentTime;
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final Map<String, Object> customData;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final ExtendedMediaStatus extendedStatus;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final IdleReason idleReason;
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final List<QueueItem> items;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final LiveSeekableRange liveSeekableRange;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Integer loadingItemId;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Media media;
    @JsonProperty
    protected final int mediaSessionId;
    @JsonProperty
    protected final float playbackRate;
    @Nonnull
    @JsonProperty
    protected final PlayerState playerState;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Integer preloadedItemId;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final QueueData queueData;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final RepeatMode repeatMode;
    @JsonProperty
    protected final int supportedMediaCommands;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final VideoInformation videoInfo;
    @Nonnull
    @JsonProperty
    protected final MediaVolume volume;

    public MediaStatus(@JsonProperty(value="activeTrackIds") @Nullable List<Integer> activeTrackIds, @JsonProperty(value="currentItemId") @Nullable Integer currentItemId, @JsonProperty(value="currentTime") double currentTime, @JsonProperty(value="customData") @Nullable Map<String, Object> customData, @JsonProperty(value="extendedStatus") @Nullable ExtendedMediaStatus extendedStatus, @JsonProperty(value="idleReason") @Nullable IdleReason idleReason, @JsonProperty(value="items") @Nullable List<QueueItem> items, @JsonProperty(value="liveSeekableRange") @Nullable LiveSeekableRange liveSeekableRange, @JsonProperty(value="loadingItemId") @Nullable Integer loadingItemId, @JsonProperty(value="media") @Nullable Media media, @JsonProperty(value="mediaSessionId") int mediaSessionId, @JsonProperty(value="playbackRate") float playbackRate, @JsonProperty(value="playerState") @Nonnull PlayerState playerState, @JsonProperty(value="preloadedItemId") @Nullable Integer preloadedItemId, @JsonProperty(value="queueData") @Nullable QueueData queueData, @JsonProperty(value="repeatMode") @Nullable RepeatMode repeatMode, @JsonProperty(value="supportedMediaCommands") int supportedMediaCommands, @JsonProperty(value="videoInfo") @Nullable VideoInformation videoInfo, @JsonProperty(value="volume") @Nonnull MediaVolume volume) {
        Util.requireNotNull((Object)playerState, "playerState");
        Util.requireNotNull(volume, "volume");
        this.activeTrackIds = activeTrackIds == null || activeTrackIds.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Integer>(activeTrackIds));
        this.currentItemId = currentItemId;
        this.currentTime = currentTime;
        this.customData = customData == null ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(customData));
        this.extendedStatus = extendedStatus;
        this.idleReason = idleReason;
        this.items = items == null || items.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<QueueItem>(items));
        this.liveSeekableRange = liveSeekableRange;
        this.loadingItemId = loadingItemId;
        this.media = media;
        this.mediaSessionId = mediaSessionId;
        this.playbackRate = playbackRate;
        this.playerState = playerState;
        this.preloadedItemId = preloadedItemId;
        this.queueData = queueData;
        this.repeatMode = repeatMode;
        this.supportedMediaCommands = supportedMediaCommands;
        this.videoInfo = videoInfo;
        this.volume = volume;
    }

    @Nonnull
    public List<Integer> getActiveTrackIds() {
        return this.activeTrackIds;
    }

    @Nullable
    public Integer getCurrentItemId() {
        return this.currentItemId;
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    @Nonnull
    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    @Nullable
    public ExtendedMediaStatus getExtendedStatus() {
        return this.extendedStatus;
    }

    @Nullable
    public IdleReason getIdleReason() {
        return this.idleReason;
    }

    @Nonnull
    public List<QueueItem> getItems() {
        return this.items;
    }

    @Nullable
    public LiveSeekableRange getLiveSeekableRange() {
        return this.liveSeekableRange;
    }

    @Nullable
    public Integer getLoadingItemId() {
        return this.loadingItemId;
    }

    @Nullable
    public Media getMedia() {
        return this.media;
    }

    public int getMediaSessionId() {
        return this.mediaSessionId;
    }

    public float getPlaybackRate() {
        return this.playbackRate;
    }

    @Nonnull
    public PlayerState getPlayerState() {
        return this.playerState;
    }

    @Nullable
    public Integer getPreloadedItemId() {
        return this.preloadedItemId;
    }

    @Nullable
    public QueueData getQueueData() {
        return this.queueData;
    }

    @Nullable
    public RepeatMode getRepeatMode() {
        return this.repeatMode;
    }

    public int getSupportedMediaCommands() {
        return this.supportedMediaCommands;
    }

    @Nullable
    public VideoInformation getVideoInfo() {
        return this.videoInfo;
    }

    @Nonnull
    public MediaVolume getVolume() {
        return this.volume;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activeTrackIds, this.currentItemId, this.currentTime, this.customData, this.extendedStatus, this.idleReason, this.items, this.liveSeekableRange, this.loadingItemId, this.media, this.mediaSessionId, Float.valueOf(this.playbackRate), this.playerState, this.preloadedItemId, this.queueData, this.repeatMode, this.supportedMediaCommands, this.videoInfo, this.volume});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MediaStatus)) {
            return false;
        }
        MediaStatus other = (MediaStatus)obj;
        return Objects.equals(this.activeTrackIds, other.activeTrackIds) && Objects.equals(this.currentItemId, other.currentItemId) && Double.doubleToLongBits(this.currentTime) == Double.doubleToLongBits(other.currentTime) && Objects.equals(this.customData, other.customData) && Objects.equals(this.extendedStatus, other.extendedStatus) && this.idleReason == other.idleReason && Objects.equals(this.items, other.items) && Objects.equals(this.liveSeekableRange, other.liveSeekableRange) && Objects.equals(this.loadingItemId, other.loadingItemId) && Objects.equals(this.media, other.media) && this.mediaSessionId == other.mediaSessionId && Float.floatToIntBits(this.playbackRate) == Float.floatToIntBits(other.playbackRate) && this.playerState == other.playerState && Objects.equals(this.preloadedItemId, other.preloadedItemId) && Objects.equals(this.queueData, other.queueData) && this.repeatMode == other.repeatMode && this.supportedMediaCommands == other.supportedMediaCommands && Objects.equals(this.videoInfo, other.videoInfo) && Objects.equals(this.volume, other.volume);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        if (this.activeTrackIds != null) {
            builder.append("activeTrackIds=").append(this.activeTrackIds).append(", ");
        }
        if (this.currentItemId != null) {
            builder.append("currentItemId=").append(this.currentItemId).append(", ");
        }
        builder.append("currentTime=").append(this.currentTime).append(", ");
        if (this.customData != null) {
            builder.append("customData=").append(this.customData).append(", ");
        }
        if (this.extendedStatus != null) {
            builder.append("extendedStatus=").append(this.extendedStatus).append(", ");
        }
        if (this.idleReason != null) {
            builder.append("idleReason=").append((Object)this.idleReason).append(", ");
        }
        if (this.items != null) {
            builder.append("items=").append(this.items).append(", ");
        }
        if (this.liveSeekableRange != null) {
            builder.append("liveSeekableRange=").append(this.liveSeekableRange).append(", ");
        }
        if (this.loadingItemId != null) {
            builder.append("loadingItemId=").append(this.loadingItemId).append(", ");
        }
        if (this.media != null) {
            builder.append("media=").append(this.media).append(", ");
        }
        builder.append("mediaSessionId=").append(this.mediaSessionId).append(", playbackRate=").append(this.playbackRate).append(", ").append("playerState=").append((Object)this.playerState).append(", ");
        if (this.preloadedItemId != null) {
            builder.append("preloadedItemId=").append(this.preloadedItemId).append(", ");
        }
        if (this.queueData != null) {
            builder.append("queueData=").append(this.queueData).append(", ");
        }
        if (this.repeatMode != null) {
            builder.append("repeatMode=").append((Object)this.repeatMode).append(", ");
        }
        builder.append("supportedMediaCommands=").append(this.supportedMediaCommands).append(", ");
        if (this.videoInfo != null) {
            builder.append("videoInfo=").append(this.videoInfo).append(", ");
        }
        builder.append("volume=").append(this.volume).append("]");
        return builder.toString();
    }

    public static enum IdleReason {
        CANCELLED,
        INTERRUPTED,
        FINISHED,
        ERROR,
        COMPLETED;


        @Nullable
        @JsonCreator
        public static IdleReason typeOf(String idleReason) {
            if (Util.isBlank(idleReason)) {
                return null;
            }
            String typeString = idleReason.toUpperCase(Locale.ROOT);
            for (IdleReason type : IdleReason.values()) {
                if (!typeString.equals(type.name())) continue;
                return type;
            }
            return null;
        }
    }

    public static enum RepeatMode {
        REPEAT_OFF,
        REPEAT_ALL,
        REPEAT_SINGLE,
        REPEAT_ALL_AND_SHUFFLE;


        @Nullable
        @JsonCreator
        public static RepeatMode typeOf(String repeatMode) {
            if (Util.isBlank(repeatMode)) {
                return null;
            }
            String typeString = repeatMode.toUpperCase(Locale.ROOT);
            for (RepeatMode type : RepeatMode.values()) {
                if (!typeString.equals(type.name())) continue;
                return type;
            }
            return null;
        }
    }

    public static enum PlayerState {
        IDLE,
        PLAYING,
        PAUSED,
        BUFFERING;


        @Nullable
        @JsonCreator
        public static PlayerState typeOf(String playerState) {
            if (Util.isBlank(playerState)) {
                return null;
            }
            String typeString = playerState.toUpperCase(Locale.ROOT);
            for (PlayerState state : PlayerState.values()) {
                if (!typeString.equals(state.name())) continue;
                return state;
            }
            return null;
        }
    }
}

