/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;
import org.digitalmediaserver.cast.MediaStatus;
import org.digitalmediaserver.cast.StandardResponse;

public class MediaStatusResponseDeserializer
extends StdDeserializer<StandardResponse.MediaStatusResponse> {
    private static final long serialVersionUID = 1L;

    public MediaStatusResponseDeserializer() {
        super((Class)null);
    }

    public MediaStatusResponseDeserializer(Class<?> vc) {
        super(vc);
    }

    public MediaStatusResponseDeserializer(JavaType valueType) {
        super(valueType);
    }

    public MediaStatusResponseDeserializer(StdDeserializer<?> src) {
        super(src);
    }

    public StandardResponse.MediaStatusResponse deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        MediaStatus[] statuses;
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        JsonNode tmpNode = node.get("requestId");
        long requestId = tmpNode == null ? -1L : tmpNode.asLong(-1L);
        tmpNode = node.get("status");
        if (tmpNode == null) {
            MediaStatus status = (MediaStatus)parser.getCodec().treeToValue((TreeNode)node, MediaStatus.class);
            return status == null ? new StandardResponse.MediaStatusResponse(requestId, new MediaStatus[0]) : new StandardResponse.MediaStatusResponse(requestId, status);
        }
        if (tmpNode.isArray()) {
            statuses = new MediaStatus[tmpNode.size()];
            int i = 0;
            Iterator iterator = tmpNode.elements();
            while (iterator.hasNext()) {
                JsonNode mediaStatusNode = (JsonNode)iterator.next();
                MediaStatus status = (MediaStatus)parser.getCodec().treeToValue((TreeNode)mediaStatusNode, MediaStatus.class);
                statuses[i++] = status;
            }
        } else {
            MediaStatus status = (MediaStatus)parser.getCodec().treeToValue((TreeNode)tmpNode, MediaStatus.class);
            statuses = status == null ? new MediaStatus[]{} : new MediaStatus[]{status};
        }
        return new StandardResponse.MediaStatusResponse(requestId, statuses);
    }
}

