/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.digitalmediaserver.cast.Image;
import org.digitalmediaserver.cast.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metadata.class);
    protected static final String[] TIME_ZONE_PATTERNS = new String[]{"Z", "+hh", "+hhmm", "+hh:mm"};
    protected static final String DATE_TIME_PATTERN = "yyyyMMdd'T'HHmmssZ";
    public static final String METADATA_TYPE = "metadataType";
    public static final String IMAGES = "images";

    @Nonnull
    public static List<Image> extractImages(@Nullable Map<String, Object> metadata) {
        ArrayList<Image> result = new ArrayList<Image>();
        if (metadata == null || metadata.isEmpty()) {
            return result;
        }
        Object object = metadata.get(IMAGES);
        if (!(object instanceof List)) {
            return result;
        }
        List untypedList = (List)object;
        if (untypedList.isEmpty()) {
            return result;
        }
        if (!(untypedList.get(0) instanceof Map)) {
            return result;
        }
        List list = untypedList;
        for (Map image : list) {
            object = image.get("url");
            if (!(object instanceof String)) continue;
            String url = (String)object;
            object = image.get("height");
            Integer height = object instanceof Integer ? (Integer)object : (object instanceof Number ? Integer.valueOf(((Number)object).intValue()) : null);
            object = image.get("width");
            Integer width = object instanceof Integer ? (Integer)object : (object instanceof Number ? Integer.valueOf(((Number)object).intValue()) : null);
            result.add(new Image(url, height, width));
        }
        return result;
    }

    public static boolean setImages(@Nullable Map<String, Object> metadata, Image ... images) {
        if (metadata == null) {
            return false;
        }
        if (images == null || images.length == 0) {
            return metadata.remove(IMAGES) != null;
        }
        return Metadata.setImages(metadata, Arrays.asList(images));
    }

    public static boolean setImages(@Nullable Map<String, Object> metadata, @Nullable Collection<Image> images) {
        if (metadata == null) {
            return false;
        }
        if (images == null || images.isEmpty()) {
            return metadata.remove(IMAGES) != null;
        }
        ArrayList imagesList = new ArrayList();
        for (Image image : images) {
            String url = image.getUrl();
            if (Util.isBlank(url)) continue;
            LinkedHashMap<String, Object> imageEntry = new LinkedHashMap<String, Object>(3);
            imageEntry.put("url", url);
            Integer intValue = image.getHeight();
            if (intValue != null) {
                imageEntry.put("height", intValue);
            }
            if ((intValue = image.getWidth()) != null) {
                imageEntry.put("width", intValue);
            }
            imagesList.add(imageEntry);
        }
        if (imagesList.isEmpty()) {
            return metadata.remove(IMAGES) != null;
        }
        metadata.put(IMAGES, imagesList);
        return true;
    }

    private Metadata() {
    }

    @Nullable
    public static String dateToString(Calendar calendar) {
        if (calendar == null) {
            LOGGER.debug("Calendar object cannot be null");
            return null;
        }
        String pattern = DATE_TIME_PATTERN;
        if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
            pattern = "yyyyMMdd";
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(calendar.getTimeZone());
        String result = format.format(calendar.getTime());
        if (result.endsWith("+0000")) {
            result = result.replace("+0000", TIME_ZONE_PATTERNS[0]);
        }
        return result;
    }

    @Nullable
    public static Calendar parseDate(String dateTimeString) {
        Date tmpDate;
        if (Util.isBlank(dateTimeString)) {
            LOGGER.debug("dateTimeString is empty or null");
            return null;
        }
        String dateString = Metadata.extractDate(dateTimeString);
        if (Util.isBlank(dateString)) {
            LOGGER.debug("Invalid date format");
            return null;
        }
        String timeString = Metadata.extractTime(dateTimeString);
        String pattern = "yyyyMMdd";
        if (!Util.isBlank(timeString)) {
            dateString = new StringBuilder(1 + dateString.length() + timeString.length()).append(dateString).append("T").append(timeString).toString();
            pattern = timeString.length() == 6 ? "yyyyMMdd'T'HHmmss" : DATE_TIME_PATTERN;
        }
        Calendar result = GregorianCalendar.getInstance();
        try {
            tmpDate = new SimpleDateFormat(pattern).parse(dateString);
        }
        catch (ParseException e) {
            LOGGER.debug("Error parsing string: {}", (Object)e.getMessage());
            LOGGER.trace("", (Throwable)e);
            return null;
        }
        result.setTime(tmpDate);
        return result;
    }

    @Nullable
    protected static String extractDate(String dateTimeString) {
        if (Util.isBlank(dateTimeString)) {
            LOGGER.debug("dateTimeString is empty or null");
            return null;
        }
        try {
            return dateTimeString.substring(0, 8);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.info("Error extracting the date: {}", (Object)e.getMessage());
            LOGGER.trace("", (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected static String extractTime(@Nullable String dateTimeString) {
        String timeString;
        if (Util.isBlank(dateTimeString)) {
            LOGGER.debug("dateTimeString is empty or null");
            return null;
        }
        int delimiter = dateTimeString.indexOf(84);
        if (delimiter != 8) {
            LOGGER.debug("T delimeter is not found");
            return null;
        }
        try {
            timeString = dateTimeString.substring(delimiter + 1);
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.debug("Error extracting the time substring: {}", (Object)e.getMessage());
            LOGGER.trace("", (Throwable)e);
            return null;
        }
        if (timeString.length() == 6) {
            return timeString;
        }
        switch (timeString.charAt(6)) {
            case '+': 
            case '-': {
                int len = timeString.length();
                if (len == 6 + TIME_ZONE_PATTERNS[1].length()) {
                    return timeString.concat("00");
                }
                if (len == 6 + TIME_ZONE_PATTERNS[2].length()) {
                    return timeString;
                }
                if (len == 6 + TIME_ZONE_PATTERNS[3].length()) {
                    return timeString.replaceAll("([\\+\\-]\\d\\d):(\\d\\d)", "$1$2");
                }
            }
            case 'Z': {
                if (timeString.length() == TIME_ZONE_PATTERNS[0].length() + 6) {
                    return timeString.substring(0, timeString.length() - 1).concat("+0000");
                }
                return null;
            }
        }
        return null;
    }

    public static enum MetadataType {
        GENERIC(0),
        MOVIE(1),
        TV_SHOW(2),
        MUSIC_TRACK(3),
        PHOTO(4),
        AUDIOBOOK_CHAPTER(5);

        private int code;

        private MetadataType(int code) {
            this.code = code;
        }

        @JsonValue
        public int getCode() {
            return this.code;
        }

        @Nullable
        @JsonCreator
        public static MetadataType typeOf(int code) {
            for (MetadataType type : MetadataType.values()) {
                if (type.code != code) continue;
                return type;
            }
            return null;
        }
    }

    public static class AudiobookChapter {
        public static final String TITLE = "title";
        public static final String SUBTITLE = "subtitle";
        public static final String BOOK_TITLE = "bookTitle";
        public static final String CHAPTER_TITLE = "chapterTitle";
        public static final String CHAPTER_NUMBER = "chapterNumber";
        public static final String QUEUE_ITEM_ID = "queueItemId";
        public static final String SECTION_DURATION = "sectionDuration";
        public static final String SECTION_START_ABSOLUTE_TIME = "sectionStartAbsoluteTime";
        public static final String SECTION_START_TIME_IN_CONTAINER = "sectionStartTimeInContainer";
        public static final String SECTION_START_TIME_IN_MEDIA = "sectionStartTimeInMedia";

        private AudiobookChapter() {
        }
    }

    public static class Photo {
        public static final String CREATION_DATE = "creationDateTime";
        public static final String TITLE = "title";
        public static final String ARTIST = "artist";
        public static final String WIDTH = "width";
        public static final String HEIGHT = "height";
        public static final String LOCATION_NAME = "location";
        public static final String LOCATION_LATITUDE = "latitude";
        public static final String LOCATION_LONGITUDE = "longitude";
        public static final String QUEUE_ITEM_ID = "queueItemId";
        public static final String SECTION_DURATION = "sectionDuration";
        public static final String SECTION_START_ABSOLUTE_TIME = "sectionStartAbsoluteTime";
        public static final String SECTION_START_TIME_IN_CONTAINER = "sectionStartTimeInContainer";
        public static final String SECTION_START_TIME_IN_MEDIA = "sectionStartTimeInMedia";

        private Photo() {
        }
    }

    public static class MusicTrack {
        public static final String RELEASE_DATE = "releaseDate";
        public static final String TITLE = "title";
        public static final String ARTIST = "artist";
        public static final String ALBUM_ARTIST = "albumArtist";
        public static final String ALBUM_TITLE = "albumName";
        public static final String COMPOSER = "composer";
        public static final String DISC_NUMBER = "discNumber";
        public static final String TRACK_NUMBER = "trackNumber";
        public static final String QUEUE_ITEM_ID = "queueItemId";
        public static final String SECTION_DURATION = "sectionDuration";
        public static final String SECTION_START_ABSOLUTE_TIME = "sectionStartAbsoluteTime";
        public static final String SECTION_START_TIME_IN_CONTAINER = "sectionStartTimeInContainer";
        public static final String SECTION_START_TIME_IN_MEDIA = "sectionStartTimeInMedia";

        private MusicTrack() {
        }
    }

    public static class TvShow {
        public static final String RELEASE_DATE = "releaseDate";
        public static final String BROADCAST_DATE = "originalAirdate";
        public static final String TITLE = "title";
        public static final String SEASON_NUMBER = "season";
        public static final String EPISODE_NUMBER = "episode";
        public static final String SERIES_TITLE = "seriesTitle";
        public static final String QUEUE_ITEM_ID = "queueItemId";
        public static final String SECTION_DURATION = "sectionDuration";
        public static final String SECTION_START_ABSOLUTE_TIME = "sectionStartAbsoluteTime";
        public static final String SECTION_START_TIME_IN_CONTAINER = "sectionStartTimeInContainer";
        public static final String SECTION_START_TIME_IN_MEDIA = "sectionStartTimeInMedia";

        private TvShow() {
        }
    }

    public static class Movie {
        public static final String RELEASE_DATE = "releaseDate";
        public static final String TITLE = "title";
        public static final String SUBTITLE = "subtitle";
        public static final String STUDIO = "studio";
        public static final String QUEUE_ITEM_ID = "queueItemId";
        public static final String SECTION_DURATION = "sectionDuration";
        public static final String SECTION_START_ABSOLUTE_TIME = "sectionStartAbsoluteTime";
        public static final String SECTION_START_TIME_IN_CONTAINER = "sectionStartTimeInContainer";
        public static final String SECTION_START_TIME_IN_MEDIA = "sectionStartTimeInMedia";

        private Movie() {
        }
    }

    public static class Generic {
        public static final String RELEASE_DATE = "releaseDate";
        public static final String TITLE = "title";
        public static final String SUBTITLE = "subtitle";
        public static final String ARTIST = "artist";
        public static final String QUEUE_ITEM_ID = "queueItemId";
        public static final String SECTION_DURATION = "sectionDuration";
        public static final String SECTION_START_ABSOLUTE_TIME = "sectionStartAbsoluteTime";
        public static final String SECTION_START_TIME_IN_CONTAINER = "sectionStartTimeInContainer";
        public static final String SECTION_START_TIME_IN_MEDIA = "sectionStartTimeInMedia";

        private Generic() {
        }
    }
}

