/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.ContainerMetadata;
import org.digitalmediaserver.cast.MediaStatus;
import org.digitalmediaserver.cast.QueueItem;

@Immutable
public class QueueData {
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final ContainerMetadata containerMetadata;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String description;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String entity;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String id;
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final List<QueueItem> items;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String name;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final QueueType queueType;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final MediaStatus.RepeatMode repeatMode;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Boolean shuffle;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Integer startIndex;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Double startTime;

    public QueueData(@JsonProperty(value="containerMetadata") ContainerMetadata containerMetadata, @JsonProperty(value="description") String description, @JsonProperty(value="entity") String entity, @JsonProperty(value="id") String id, @JsonProperty(value="items") List<QueueItem> items, @JsonProperty(value="name") String name, @JsonProperty(value="queueType") QueueType queueType, @JsonProperty(value="repeatMode") MediaStatus.RepeatMode repeatMode, @JsonProperty(value="shuffle") Boolean shuffle, @JsonProperty(value="startIndex") Integer startIndex, @JsonProperty(value="startTime") Double startTime) {
        this.containerMetadata = containerMetadata;
        this.description = description;
        this.entity = entity;
        this.id = id;
        this.items = items == null || items.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<QueueItem>(items));
        this.name = name;
        this.queueType = queueType;
        this.repeatMode = repeatMode;
        this.shuffle = shuffle;
        this.startIndex = startIndex;
        this.startTime = startTime;
    }

    @Nullable
    public ContainerMetadata getContainerMetadata() {
        return this.containerMetadata;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getEntity() {
        return this.entity;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nonnull
    public List<QueueItem> getItems() {
        return this.items;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public QueueType getQueueType() {
        return this.queueType;
    }

    @Nullable
    public MediaStatus.RepeatMode getRepeatMode() {
        return this.repeatMode;
    }

    @Nullable
    public Boolean getShuffle() {
        return this.shuffle;
    }

    @Nullable
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Nullable
    public Double getStartTime() {
        return this.startTime;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerMetadata, this.description, this.entity, this.id, this.items, this.name, this.queueType, this.repeatMode, this.shuffle, this.startIndex, this.startTime});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QueueData)) {
            return false;
        }
        QueueData other = (QueueData)obj;
        return Objects.equals(this.containerMetadata, other.containerMetadata) && Objects.equals(this.description, other.description) && Objects.equals(this.entity, other.entity) && Objects.equals(this.id, other.id) && Objects.equals(this.items, other.items) && Objects.equals(this.name, other.name) && this.queueType == other.queueType && this.repeatMode == other.repeatMode && Objects.equals(this.shuffle, other.shuffle) && Objects.equals(this.startIndex, other.startIndex) && Objects.equals(this.startTime, other.startTime);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        if (this.containerMetadata != null) {
            builder.append("containerMetadata=").append(this.containerMetadata).append(", ");
        }
        if (this.description != null) {
            builder.append("description=").append(this.description).append(", ");
        }
        if (this.entity != null) {
            builder.append("entity=").append(this.entity).append(", ");
        }
        if (this.id != null) {
            builder.append("id=").append(this.id).append(", ");
        }
        if (!this.items.isEmpty()) {
            builder.append("items=").append(this.items).append(", ");
        }
        if (this.name != null) {
            builder.append("name=").append(this.name).append(", ");
        }
        if (this.queueType != null) {
            builder.append("queueType=").append((Object)this.queueType).append(", ");
        }
        if (this.repeatMode != null) {
            builder.append("repeatMode=").append((Object)this.repeatMode).append(", ");
        }
        if (this.shuffle != null) {
            builder.append("shuffle=").append(this.shuffle).append(", ");
        }
        if (this.startIndex != null) {
            builder.append("startIndex=").append(this.startIndex).append(", ");
        }
        if (this.startTime != null) {
            builder.append("startTime=").append(this.startTime);
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum QueueType {
        ALBUM,
        PLAYLIST,
        AUDIOBOOK,
        RADIO_STATION,
        PODCAST_SERIES,
        TV_SERIES,
        VIDEO_PLAYLIST,
        LIVE_TV,
        MOVIE;

    }
}

