/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.Media;

@Immutable
public class QueueItem {
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final List<Integer> activeTrackIds;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Boolean autoplay;
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final Map<String, Object> customData;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Integer itemId;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Media media;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Integer orderId;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Double preloadTime;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Double startTime;

    public QueueItem(@Nullable List<Integer> activeTrackIds, @Nullable Boolean autoplay, @Nullable Media media, @Nullable Double preloadTime, @Nullable Double startTime) {
        this(activeTrackIds, autoplay, null, null, media, null, preloadTime, startTime);
    }

    public QueueItem(@JsonProperty(value="activeTrackIds") @Nullable List<Integer> activeTrackIds, @JsonProperty(value="autoplay") @Nullable Boolean autoplay, @JsonProperty(value="customData") @Nullable Map<String, Object> customData, @JsonProperty(value="itemId") @Nullable Integer itemId, @JsonProperty(value="media") @Nullable Media media, @JsonProperty(value="orderId") @Nullable Integer orderId, @JsonProperty(value="preloadTime") @Nullable Double preloadTime, @JsonProperty(value="startTime") @Nullable Double startTime) {
        this.activeTrackIds = activeTrackIds == null || activeTrackIds.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Integer>(activeTrackIds));
        this.autoplay = autoplay;
        this.customData = customData == null || customData.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(customData));
        this.itemId = itemId;
        this.media = media;
        this.orderId = orderId;
        this.preloadTime = preloadTime;
        this.startTime = startTime;
    }

    @Nonnull
    public List<Integer> getActiveTrackIds() {
        return this.activeTrackIds;
    }

    @Nullable
    public Boolean getAutoplay() {
        return this.autoplay;
    }

    @Nonnull
    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    @Nullable
    public Integer getItemId() {
        return this.itemId;
    }

    @Nullable
    public Media getMedia() {
        return this.media;
    }

    @Nullable
    public Integer getOrderId() {
        return this.orderId;
    }

    @Nullable
    public Double getPreloadTime() {
        return this.preloadTime;
    }

    @Nullable
    public Double getStartTime() {
        return this.startTime;
    }

    public int hashCode() {
        return Objects.hash(this.activeTrackIds, this.autoplay, this.customData, this.itemId, this.media, this.orderId, this.preloadTime, this.startTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QueueItem)) {
            return false;
        }
        QueueItem other = (QueueItem)obj;
        return Objects.equals(this.activeTrackIds, other.activeTrackIds) && Objects.equals(this.autoplay, other.autoplay) && Objects.equals(this.customData, other.customData) && Objects.equals(this.itemId, other.itemId) && Objects.equals(this.media, other.media) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.preloadTime, other.preloadTime) && Objects.equals(this.startTime, other.startTime);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        if (this.activeTrackIds != null) {
            builder.append("activeTrackIds=").append(this.activeTrackIds).append(", ");
        }
        if (this.autoplay != null) {
            builder.append("autoplay=").append(this.autoplay).append(", ");
        }
        if (this.customData != null) {
            builder.append("customData=").append(this.customData).append(", ");
        }
        if (this.itemId != null) {
            builder.append("itemId=").append(this.itemId).append(", ");
        }
        if (this.media != null) {
            builder.append("media=").append(this.media).append(", ");
        }
        if (this.orderId != null) {
            builder.append("orderId=").append(this.orderId).append(", ");
        }
        if (this.preloadTime != null) {
            builder.append("preloadTime=").append(this.preloadTime).append(", ");
        }
        if (this.startTime != null) {
            builder.append("startTime=").append(this.startTime);
        }
        builder.append("]");
        return builder.toString();
    }
}

