/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.Application;
import org.digitalmediaserver.cast.Volume;

@Immutable
public class ReceiverStatus {
    @Nullable
    protected final Volume volume;
    @Nonnull
    protected final List<Application> applications;
    protected final boolean activeInput;
    protected final boolean standBy;

    public ReceiverStatus(@JsonProperty(value="volume") @Nullable Volume volume, @JsonProperty(value="applications") @Nullable List<Application> applications, @JsonProperty(value="isActiveInput") boolean activeInput, @JsonProperty(value="isStandBy") boolean standBy) {
        this.volume = volume;
        this.applications = applications == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<Application>(applications));
        this.activeInput = activeInput;
        this.standBy = standBy;
    }

    @Nullable
    public Volume getVolume() {
        return this.volume;
    }

    @Nonnull
    public List<Application> getApplications() {
        return this.applications;
    }

    public boolean isActiveInput() {
        return this.activeInput;
    }

    public boolean isStandBy() {
        return this.standBy;
    }

    @Nullable
    @JsonIgnore
    public Application getRunningApplication() {
        return this.applications.isEmpty() ? null : this.applications.get(0);
    }

    public boolean isApplicationRunning(String applicationId) {
        Application runningApplication = this.getRunningApplication();
        return runningApplication != null && runningApplication.getAppId().equals(applicationId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(" [");
        if (this.volume != null) {
            builder.append("volume=").append(this.volume).append(", ");
        }
        if (this.applications != null) {
            builder.append("applications=").append(this.applications).append(", ");
        }
        builder.append("activeInput=").append(this.activeInput).append(", standBy=").append(this.standBy).append("]");
        return builder.toString();
    }
}

