/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.digitalmediaserver.cast.Channel;
import org.digitalmediaserver.cast.LoadOptions;
import org.digitalmediaserver.cast.Media;
import org.digitalmediaserver.cast.MediaStatus;
import org.digitalmediaserver.cast.MediaVolume;
import org.digitalmediaserver.cast.QueueData;
import org.digitalmediaserver.cast.Request;
import org.digitalmediaserver.cast.Response;
import org.digitalmediaserver.cast.StandardRequest;
import org.digitalmediaserver.cast.Util;

@ThreadSafe
public class Session {
    @Nonnull
    protected final String sourceId;
    @Nonnull
    protected final String id;
    @Nonnull
    protected final String destinationId;
    @Nonnull
    protected final Channel channel;
    @Nonnull
    protected final Object listenerLock = new Object();
    @Nullable
    @GuardedBy(value="listenerLock")
    protected SessionClosedListener listener;

    public Session(@Nonnull String sourceId, @Nonnull String sessionId, @Nonnull String destinationId, @Nonnull Channel channel) {
        Util.requireNotBlank(sourceId, "sourceId");
        Util.requireNotBlank(sessionId, "sessionId");
        Util.requireNotBlank(destinationId, "destinationId");
        Util.requireNotNull(channel, "channel");
        this.sourceId = sourceId;
        this.id = sessionId;
        this.destinationId = destinationId;
        this.channel = channel;
    }

    @Nonnull
    public String getSourceId() {
        return this.sourceId;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getDestinationId() {
        return this.destinationId;
    }

    public boolean isClosed() {
        return this.channel.isSessionClosed(this);
    }

    public boolean close() throws IOException {
        return this.channel.closeSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SessionClosedListener getSessionClosedListener() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionClosedListener(@Nullable SessionClosedListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listener = listener;
        }
    }

    @Nullable
    public MediaStatus load(@Nonnull StandardRequest.Load loadRequest, boolean synchronous) throws IOException {
        return this.channel.load(this, loadRequest, synchronous, 30000L);
    }

    @Nullable
    public MediaStatus load(@Nonnull StandardRequest.Load loadRequest, boolean synchronous, long responseTimeout) throws IOException {
        return this.channel.load(this, loadRequest, synchronous, responseTimeout);
    }

    @Nullable
    public MediaStatus load(@Nonnull Media.MediaBuilder mediaBuilder, @Nullable Boolean autoplay, @Nullable Double currentTime, boolean synchronous) throws IOException {
        Util.requireNotNull(mediaBuilder, "mediaBuilder");
        return this.channel.load(this, autoplay, currentTime, mediaBuilder.build(), synchronous, 30000L);
    }

    @Nullable
    public MediaStatus load(@Nonnull Media.MediaBuilder mediaBuilder, @Nullable Boolean autoplay, @Nullable Double currentTime, boolean synchronous, long responseTimeout) throws IOException {
        Util.requireNotNull(mediaBuilder, "mediaBuilder");
        return this.channel.load(this, autoplay, currentTime, mediaBuilder.build(), synchronous, responseTimeout);
    }

    @Nullable
    public MediaStatus load(@Nonnull Media media, @Nullable Boolean autoplay, @Nullable Double currentTime, boolean synchronous) throws IOException {
        return this.channel.load(this, autoplay, currentTime, media, synchronous, 30000L);
    }

    @Nullable
    public MediaStatus load(@Nonnull Media media, @Nullable Boolean autoplay, @Nullable Double currentTime, boolean synchronous, long responseTimeout) throws IOException {
        return this.channel.load(this, autoplay, currentTime, media, synchronous, responseTimeout);
    }

    @Nullable
    public MediaStatus load(@Nonnull Media media, @Nullable List<Integer> activeTrackIds, @Nullable Boolean autoplay, @Nullable Double currentTime, @Nullable Double playbackRate, boolean synchronous) throws IOException {
        return this.channel.load(this, activeTrackIds, autoplay, null, null, currentTime, null, null, media, playbackRate, null, synchronous, 30000L);
    }

    @Nullable
    public MediaStatus load(@Nonnull Media media, @Nullable List<Integer> activeTrackIds, @Nullable Boolean autoplay, @Nullable Double currentTime, @Nullable Double playbackRate, boolean synchronous, long responseTimeout) throws IOException {
        return this.channel.load(this, activeTrackIds, autoplay, null, null, currentTime, null, null, media, playbackRate, null, synchronous, responseTimeout);
    }

    @Nullable
    public MediaStatus load(@Nonnull Media media, @Nullable List<Integer> activeTrackIds, @Nullable Boolean autoplay, @Nullable String credentials, @Nullable String credentialsType, @Nullable Double currentTime, @Nullable Map<String, Object> customData, @Nullable LoadOptions loadOptions, @Nullable Double playbackRate, @Nullable QueueData queueData, boolean synchronous) throws IOException {
        return this.channel.load(this, activeTrackIds, autoplay, credentials, credentialsType, currentTime, customData, loadOptions, media, playbackRate, queueData, synchronous, 30000L);
    }

    @Nullable
    public MediaStatus load(@Nonnull Media media, @Nullable List<Integer> activeTrackIds, @Nullable Boolean autoplay, @Nullable String credentials, @Nullable String credentialsType, @Nullable Double currentTime, @Nullable Map<String, Object> customData, @Nullable LoadOptions loadOptions, @Nullable Double playbackRate, @Nullable QueueData queueData, boolean synchronous, long responseTimeout) throws IOException {
        return this.channel.load(this, activeTrackIds, autoplay, credentials, credentialsType, currentTime, customData, loadOptions, media, playbackRate, queueData, synchronous, responseTimeout);
    }

    @Nullable
    public MediaStatus play(int mediaSessionId, boolean synchronous) throws IOException {
        return this.channel.play(this, mediaSessionId, synchronous);
    }

    @Nullable
    public MediaStatus play(int mediaSessionId, boolean synchronous, long responseTimeout) throws IOException {
        return this.channel.play(this, mediaSessionId, synchronous, responseTimeout);
    }

    @Nullable
    public MediaStatus pause(int mediaSessionId, boolean synchronous) throws IOException {
        return this.channel.pause(this, mediaSessionId, synchronous);
    }

    @Nullable
    public MediaStatus pause(int mediaSessionId, boolean synchronous, long responseTimeout) throws IOException {
        return this.channel.pause(this, mediaSessionId, synchronous, responseTimeout);
    }

    @Nullable
    public MediaStatus seek(int mediaSessionId, double currentTime, @Nullable StandardRequest.ResumeState resumeState, boolean synchronous) throws IOException {
        return this.channel.seek(this, mediaSessionId, currentTime, resumeState, synchronous);
    }

    @Nullable
    public MediaStatus seek(int mediaSessionId, double currentTime, @Nullable StandardRequest.ResumeState resumeState, boolean synchronous, long responseTimeout) throws IOException {
        return this.channel.seek(this, mediaSessionId, currentTime, resumeState, synchronous, responseTimeout);
    }

    @Nullable
    public MediaStatus stop(int mediaSessionId, boolean synchronous) throws IOException {
        return this.channel.stopMedia(this, mediaSessionId, synchronous);
    }

    @Nullable
    public MediaStatus stop(int mediaSessionId, boolean synchronous, long responseTimeout) throws IOException {
        return this.channel.stopMedia(this, mediaSessionId, synchronous, responseTimeout);
    }

    @Nullable
    public MediaStatus setVolume(int mediaSessionId, @Nonnull MediaVolume volume, boolean synchronous) throws IOException {
        return this.channel.setMediaVolume(this, mediaSessionId, volume, synchronous);
    }

    @Nullable
    public MediaStatus getMediaStatus() throws IOException {
        return this.channel.getMediaStatus(this);
    }

    @Nullable
    public MediaStatus getMediaStatus(long responseTimeout) throws IOException {
        return this.channel.getMediaStatus(this, responseTimeout);
    }

    public <T extends Response> T sendGenericRequest(String namespace, Request request, Class<T> responseClass) throws IOException {
        return this.channel.sendGenericRequest(this, namespace, request, responseClass);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        if (this.sourceId != null) {
            builder.append("sourceId=").append(this.sourceId).append(", ");
        }
        if (this.id != null) {
            builder.append("id=").append(this.id).append(", ");
        }
        if (this.destinationId != null) {
            builder.append("destinationId=").append(this.destinationId).append(", ");
        }
        builder.append("closed=").append(this.isClosed()).append("]");
        return builder.toString();
    }

    public static interface SessionClosedListener {
        public void closed(@Nonnull Session var1);
    }
}

