/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.digitalmediaserver.cast.LoadOptions;
import org.digitalmediaserver.cast.Media;
import org.digitalmediaserver.cast.MediaVolume;
import org.digitalmediaserver.cast.QueueData;
import org.digitalmediaserver.cast.Request;
import org.digitalmediaserver.cast.StandardMessage;
import org.digitalmediaserver.cast.Util;
import org.digitalmediaserver.cast.Volume;

public abstract class StandardRequest
extends StandardMessage
implements Request {
    protected long requestId;

    @Override
    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    public static enum ResumeState {
        PLAYBACK_START,
        PLAYBACK_PAUSE;

    }

    public static class StopMedia
    implements Request {
        @JsonProperty
        protected final int mediaSessionId;
        @JsonProperty
        protected long requestId;
        @JsonProperty
        protected final String type = "STOP";
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        protected final Map<String, Object> customData;

        public StopMedia(int mediaSessionId, @Nullable Map<String, Object> customData) {
            this.mediaSessionId = mediaSessionId;
            this.customData = customData;
        }

        @Nullable
        public Map<String, Object> getCustomData() {
            return this.customData;
        }

        @Override
        public void setRequestId(long requestId) {
            this.requestId = requestId;
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        public int getMediaSessionId() {
            return this.mediaSessionId;
        }
    }

    public static class VolumeRequest
    implements Request {
        @JsonProperty
        protected final int mediaSessionId;
        @JsonProperty
        protected final String sessionId;
        @JsonProperty
        protected long requestId;
        @JsonProperty
        protected final String type = "SET_VOLUME";
        @Nonnull
        @JsonProperty
        protected final MediaVolume volume;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        protected final Map<String, Object> customData;

        public VolumeRequest(String sessionId, int mediaSessionId, @Nonnull MediaVolume volume, @Nullable Map<String, Object> customData) {
            Util.requireNotBlank(sessionId, "sessionId");
            Util.requireNotNull(volume, "volume");
            this.sessionId = sessionId;
            this.mediaSessionId = mediaSessionId;
            this.volume = volume;
            this.customData = customData;
        }

        @Nonnull
        public MediaVolume getVolume() {
            return this.volume;
        }

        @Nullable
        public Map<String, Object> getCustomData() {
            return this.customData;
        }

        @Override
        public void setRequestId(long requestId) {
            this.requestId = requestId;
        }

        @Override
        public long getRequestId() {
            return this.requestId;
        }

        public int getMediaSessionId() {
            return this.mediaSessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }
    }

    public static class SetVolume
    extends StandardRequest {
        @JsonProperty
        protected final Volume volume;

        public SetVolume(Volume volume) {
            this.volume = volume;
        }

        public Volume getVolume() {
            return this.volume;
        }
    }

    public static class Seek
    extends MediaRequest {
        @JsonProperty
        protected final double currentTime;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        protected final Map<String, Object> customData;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected final ResumeState resumeState;

        public Seek(int mediaSessionId, @Nonnull String sessionId, double currentTime, @Nullable ResumeState resumeState) {
            super(mediaSessionId, sessionId);
            this.currentTime = currentTime;
            this.customData = null;
            this.resumeState = resumeState;
        }

        public Seek(int mediaSessionId, @Nonnull String sessionId, double currentTime, @Nullable Map<String, Object> customData, @Nullable ResumeState resumeState) {
            super(mediaSessionId, sessionId);
            this.currentTime = currentTime;
            this.customData = customData;
            this.resumeState = resumeState;
        }

        public double getCurrentTime() {
            return this.currentTime;
        }

        @Nullable
        public Map<String, Object> getCustomData() {
            return this.customData;
        }

        @Nullable
        public ResumeState getResumeState() {
            return this.resumeState;
        }
    }

    public static class Pause
    extends MediaRequest {
        public Pause(int mediaSessionId, String sessionId) {
            super(mediaSessionId, sessionId);
        }
    }

    public static class Play
    extends MediaRequest {
        public Play(int mediaSessionId, String sessionId) {
            super(mediaSessionId, sessionId);
        }
    }

    public static abstract class MediaRequest
    extends StandardRequest {
        @JsonProperty
        protected final int mediaSessionId;
        @JsonProperty
        protected final String sessionId;

        public MediaRequest(int mediaSessionId, String sessionId) {
            this.mediaSessionId = mediaSessionId;
            this.sessionId = sessionId;
        }

        public int getMediaSessionId() {
            return this.mediaSessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }
    }

    public static class Load
    extends StandardRequest {
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        protected final List<Integer> activeTrackIds;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected final Boolean autoplay;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected final String credentials;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected final String credentialsType;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected final Double currentTime;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        protected final Map<String, Object> customData;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected final LoadOptions loadOptions;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected final Media media;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected final Double playbackRate;
        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected final QueueData queueData;

        public Load(@Nullable List<Integer> activeTrackIds, @Nullable Boolean autoplay, @Nullable String credentials, @Nullable String credentialsType, @Nullable Double currentTime, @Nullable Map<String, Object> customData, @Nullable LoadOptions loadOptions, @Nullable Media media, @Nullable Double playbackRate, @Nullable QueueData queueData) {
            this.activeTrackIds = activeTrackIds;
            this.autoplay = autoplay;
            this.credentials = credentials;
            this.credentialsType = credentialsType;
            this.currentTime = currentTime;
            this.customData = customData;
            this.loadOptions = loadOptions;
            this.media = media;
            this.playbackRate = playbackRate;
            this.queueData = queueData;
        }

        @Nullable
        public List<Integer> getActiveTrackIds() {
            return this.activeTrackIds;
        }

        @Nullable
        public Boolean getAutoplay() {
            return this.autoplay;
        }

        @Nullable
        public String getCredentials() {
            return this.credentials;
        }

        @Nullable
        public String getCredentialsType() {
            return this.credentialsType;
        }

        @Nullable
        public Double getCurrentTime() {
            return this.currentTime;
        }

        @Nullable
        public Map<String, Object> getCustomData() {
            return this.customData;
        }

        @Nullable
        public LoadOptions getLoadOptions() {
            return this.loadOptions;
        }

        @Nullable
        public Media getMedia() {
            return this.media;
        }

        @Nullable
        public Double getPlaybackRate() {
            return this.playbackRate;
        }

        @Nullable
        public QueueData getQueueData() {
            return this.queueData;
        }
    }

    public static class Stop
    extends StandardRequest {
        @JsonProperty
        protected final String sessionId;

        public Stop(String sessionId) {
            this.sessionId = sessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }
    }

    public static class Launch
    extends StandardRequest {
        @JsonProperty
        protected final String appId;

        public Launch(@JsonProperty(value="appId") String appId) {
            this.appId = appId;
        }

        public String getAppId() {
            return this.appId;
        }
    }

    public static class GetAppAvailability
    extends StandardRequest {
        @JsonProperty
        protected final String[] appId;

        public GetAppAvailability(String ... appId) {
            this.appId = appId;
        }

        public String[] getAppId() {
            return this.appId;
        }
    }

    public static class GetStatus
    extends StandardRequest {
    }
}

