/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.CastEvent;
import org.digitalmediaserver.cast.Device;
import org.digitalmediaserver.cast.MediaStatus;
import org.digitalmediaserver.cast.MediaStatusResponseDeserializer;
import org.digitalmediaserver.cast.MultizoneStatus;
import org.digitalmediaserver.cast.ReceiverStatus;
import org.digitalmediaserver.cast.Response;
import org.digitalmediaserver.cast.Util;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="responseType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(name="PING", value=PingResponse.class), @JsonSubTypes.Type(name="PONG", value=PongResponse.class), @JsonSubTypes.Type(name="RECEIVER_STATUS", value=ReceiverStatusResponse.class), @JsonSubTypes.Type(name="ERROR", value=ErrorResponse.class), @JsonSubTypes.Type(name="GET_APP_AVAILABILITY", value=AppAvailabilityResponse.class), @JsonSubTypes.Type(name="INVALID_PLAYER_STATE", value=ErrorResponse.class), @JsonSubTypes.Type(name="INVALID_REQUEST", value=ErrorResponse.class), @JsonSubTypes.Type(name="MEDIA_STATUS", value=MediaStatusResponse.class), @JsonSubTypes.Type(name="MULTIZONE_STATUS", value=MultizoneStatusResponse.class), @JsonSubTypes.Type(name="CLOSE", value=CloseResponse.class), @JsonSubTypes.Type(name="LOAD_CANCELLED", value=ErrorResponse.class), @JsonSubTypes.Type(name="LOAD_FAILED", value=ErrorResponse.class), @JsonSubTypes.Type(name="LAUNCH_ERROR", value=LaunchErrorResponse.class), @JsonSubTypes.Type(name="DEVICE_ADDED", value=DeviceAddedResponse.class), @JsonSubTypes.Type(name="DEVICE_UPDATED", value=DeviceUpdatedResponse.class), @JsonSubTypes.Type(name="DEVICE_REMOVED", value=DeviceRemovedResponse.class)})
@Immutable
public abstract class StandardResponse
implements Response {
    protected final long requestId;

    protected StandardResponse(@JsonProperty(value="requestId") long requestId) {
        this.requestId = requestId;
    }

    @Override
    @JsonProperty
    public long getRequestId() {
        return this.requestId;
    }

    @Nullable
    @JsonIgnore
    public abstract CastEvent.CastEventType getEventType();

    public static enum DetailedErrorCode {
        MEDIA_UNKNOWN(100),
        MEDIA_ABORTED(101),
        MEDIA_DECODE(102),
        MEDIA_NETWORK(103),
        MEDIA_SRC_NOT_SUPPORTED(104),
        SOURCE_BUFFER_FAILURE(110),
        MEDIAKEYS_UNKNOWN(200),
        MEDIAKEYS_NETWORK(201),
        MEDIAKEYS_UNSUPPORTED(202),
        MEDIAKEYS_WEBCRYPTO(203),
        NETWORK_UNKNOWN(300),
        SEGMENT_NETWORK(301),
        HLS_NETWORK_MASTER_PLAYLIST(311),
        HLS_NETWORK_PLAYLIST(312),
        HLS_NETWORK_NO_KEY_RESPONSE(313),
        HLS_NETWORK_KEY_LOAD(314),
        HLS_NETWORK_INVALID_SEGMENT(315),
        HLS_SEGMENT_PARSING(316),
        DASH_NETWORK(321),
        DASH_NO_INIT(322),
        SMOOTH_NETWORK(331),
        SMOOTH_NO_MEDIA_DATA(332),
        MANIFEST_UNKNOWN(400),
        HLS_MANIFEST_MASTER(411),
        HLS_MANIFEST_PLAYLIST(412),
        DASH_MANIFEST_UNKNOWN(420),
        DASH_MANIFEST_NO_PERIODS(421),
        DASH_MANIFEST_NO_MIMETYPE(422),
        DASH_INVALID_SEGMENT_INFO(423),
        SMOOTH_MANIFEST(431),
        SEGMENT_UNKNOWN(500),
        TEXT_UNKNOWN(600),
        APP(900),
        BREAK_CLIP_LOADING_ERROR(901),
        BREAK_SEEK_INTERCEPTOR_ERROR(902),
        IMAGE_ERROR(903),
        LOAD_INTERRUPTED(904),
        LOAD_FAILED(905),
        MEDIA_ERROR_MESSAGE(906),
        GENERIC(999);

        private final int code;

        private DetailedErrorCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        @JsonCreator
        @Nullable
        public static DetailedErrorCode typeOf(int code) {
            for (DetailedErrorCode errorCode : DetailedErrorCode.values()) {
                if (errorCode.code != code) continue;
                return errorCode;
            }
            return null;
        }
    }

    public static enum ErrorType {
        INVALID_PLAYER_STATE,
        LOAD_FAILED,
        LOAD_CANCELLED,
        INVALID_REQUEST,
        ERROR;


        @Nullable
        @JsonCreator
        public static ErrorType typeOf(String errorType) {
            if (Util.isBlank(errorType)) {
                return null;
            }
            String typeString = errorType.toUpperCase(Locale.ROOT);
            for (ErrorType type : ErrorType.values()) {
                if (!typeString.equals(type.name())) continue;
                return type;
            }
            return null;
        }
    }

    public static enum ErrorReason {
        INVALID_COMMAND,
        INVALID_PARAMS,
        INVALID_MEDIA_SESSION_ID,
        SKIP_LIMIT_REACHED,
        NOT_SUPPORTED,
        LANGUAGE_NOT_SUPPORTED,
        END_OF_QUEUE,
        DUPLICATE_REQUEST_ID,
        VIDEO_DEVICE_REQUIRED,
        PREMIUM_ACCOUNT_REQUIRED,
        APP_ERROR,
        AUTHENTICATION_EXPIRED,
        CONCURRENT_STREAM_LIMIT,
        PARENTAL_CONTROL_RESTRICTED,
        CONTENT_FILTERED,
        NOT_AVAILABLE_IN_REGION,
        CONTENT_ALREADY_PLAYING,
        INVALID_REQUEST,
        GENERIC_LOAD_ERROR;


        @Nullable
        @JsonCreator
        public static ErrorReason typeOf(String errorReason) {
            if (Util.isBlank(errorReason)) {
                return null;
            }
            String typeString = errorReason.toUpperCase(Locale.ROOT);
            for (ErrorReason type : ErrorReason.values()) {
                if (!typeString.equals(type.name())) continue;
                return type;
            }
            return null;
        }
    }

    @Immutable
    public static class DeviceRemovedResponse
    extends StandardResponse {
        @JsonProperty
        protected final String deviceId;

        public DeviceRemovedResponse(@JsonProperty(value="requestId") long requestId, @JsonProperty(value="deviceId") String deviceId) {
            super(requestId);
            this.deviceId = deviceId;
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return CastEvent.CastEventType.DEVICE_REMOVED;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(" [").append("requestId=").append(this.getRequestId());
            if (this.deviceId != null) {
                builder.append(", deviceId=").append(this.deviceId);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    @Immutable
    public static class DeviceUpdatedResponse
    extends StandardResponse {
        @JsonProperty
        protected final Device device;

        public DeviceUpdatedResponse(@JsonProperty(value="requestId") long requestId, @JsonProperty(value="device") Device device) {
            super(requestId);
            this.device = device;
        }

        public Device getDevice() {
            return this.device;
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return CastEvent.CastEventType.DEVICE_UPDATED;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(" [").append("requestId=").append(this.getRequestId());
            if (this.device != null) {
                builder.append(", device=").append(this.device);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    @Immutable
    public static class DeviceAddedResponse
    extends StandardResponse {
        @JsonProperty
        protected final Device device;

        public DeviceAddedResponse(@JsonProperty(value="requestId") long requestId, @JsonProperty(value="device") Device device) {
            super(requestId);
            this.device = device;
        }

        public Device getDevice() {
            return this.device;
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return CastEvent.CastEventType.DEVICE_ADDED;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(" [").append("requestId=").append(this.getRequestId());
            if (this.device != null) {
                builder.append(", device=").append(this.device);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    @Immutable
    public static class MultizoneStatusResponse
    extends StandardResponse {
        @JsonProperty
        protected final MultizoneStatus status;

        public MultizoneStatusResponse(@JsonProperty(value="requestId") long requestId, @JsonProperty(value="status") MultizoneStatus status) {
            super(requestId);
            this.status = status;
        }

        public MultizoneStatus getStatus() {
            return this.status;
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return CastEvent.CastEventType.MULTIZONE_STATUS;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(" [").append("requestId=").append(this.getRequestId());
            if (this.status != null) {
                builder.append(", status=").append(this.status);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    @Immutable
    public static class AppAvailabilityResponse
    extends StandardResponse {
        @Nonnull
        @JsonProperty
        protected final Map<String, String> availability;

        public AppAvailabilityResponse(@JsonProperty(value="requestId") long requestId, @JsonProperty(value="availability") Map<String, String> availability) {
            super(requestId);
            this.availability = availability == null || availability.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, String>(availability));
        }

        @Nonnull
        public Map<String, String> getAvailability() {
            return this.availability;
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return CastEvent.CastEventType.APPLICATION_AVAILABILITY;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(" [").append("requestId=").append(this.getRequestId());
            if (this.availability != null) {
                builder.append(", availability=").append(this.availability);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    @JsonDeserialize(using=MediaStatusResponseDeserializer.class)
    @Immutable
    public static class MediaStatusResponse
    extends StandardResponse {
        @JsonProperty
        protected final List<MediaStatus> statuses;

        public MediaStatusResponse(@JsonProperty(value="requestId") long requestId, MediaStatus ... statuses) {
            super(requestId);
            this.statuses = statuses == null || statuses.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<MediaStatus>(Arrays.asList(statuses)));
        }

        @Nonnull
        @JsonProperty(value="status")
        public List<MediaStatus> getStatuses() {
            return this.statuses;
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return CastEvent.CastEventType.MEDIA_STATUS;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(" [").append("requestId=").append(this.getRequestId());
            if (this.statuses != null) {
                builder.append(", statuses=").append(this.statuses);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    @Immutable
    public static class ReceiverStatusResponse
    extends StandardResponse {
        @JsonProperty
        protected final ReceiverStatus status;

        public ReceiverStatusResponse(@JsonProperty(value="requestId") long requestId, @JsonProperty(value="status") ReceiverStatus status) {
            super(requestId);
            this.status = status;
        }

        public ReceiverStatus getStatus() {
            return this.status;
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return CastEvent.CastEventType.RECEIVER_STATUS;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(" [").append("requestId=").append(this.getRequestId());
            if (this.status != null) {
                builder.append(", status=").append(this.status);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    @Immutable
    public static class LaunchErrorResponse
    extends StandardResponse {
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        protected final String reason;

        public LaunchErrorResponse(@JsonProperty(value="requestId") long requestId, @JsonProperty(value="reason") String reason) {
            super(requestId);
            this.reason = reason;
        }

        public String getReason() {
            return this.reason;
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return CastEvent.CastEventType.LAUNCH_ERROR;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append(" [").append("requestId=").append(this.getRequestId());
            if (this.reason != null) {
                builder.append(", reason=").append(this.reason);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    @Immutable
    public static class ErrorResponse
    extends StandardResponse {
        @Nullable
        protected final Map<String, Object> customData;
        @Nullable
        protected final DetailedErrorCode detailedErrorCode;
        @Nullable
        protected final Integer itemId;
        @Nullable
        protected final ErrorReason reason;
        @Nullable
        protected final ErrorType type;

        public ErrorResponse(@JsonProperty(value="customData") @Nullable Map<String, Object> customData, @JsonProperty(value="detailedErrorCode") @Nullable DetailedErrorCode detailedErrorCode, @JsonProperty(value="itemId") @Nullable Integer itemId, @JsonProperty(value="reason") @Nullable ErrorReason reason, @JsonProperty(value="requestId") long requestId, @JsonProperty(value="responseType") @Nullable ErrorType type) {
            super(requestId);
            this.customData = customData;
            this.detailedErrorCode = detailedErrorCode;
            this.itemId = itemId;
            this.reason = reason;
            this.type = type;
        }

        @Nullable
        public Map<String, Object> getCustomData() {
            return this.customData;
        }

        @Nullable
        public DetailedErrorCode getDetailedErrorCode() {
            return this.detailedErrorCode;
        }

        @Nullable
        public Integer getItemId() {
            return this.itemId;
        }

        @Nullable
        public ErrorReason getReason() {
            return this.reason;
        }

        @Nullable
        public ErrorType getType() {
            return this.type;
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return CastEvent.CastEventType.ERROR_RESPONSE;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.requestId, this.customData, this.detailedErrorCode, this.itemId, this.reason, this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ErrorResponse)) {
                return false;
            }
            ErrorResponse other = (ErrorResponse)obj;
            return Objects.equals(this.requestId, other.requestId) && Objects.equals(this.customData, other.customData) && Objects.equals((Object)this.detailedErrorCode, (Object)other.detailedErrorCode) && Objects.equals(this.itemId, other.itemId) && this.reason == other.reason && this.type == other.type;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ErrorResponse [");
            if (this.customData != null) {
                builder.append("customData=").append(this.customData).append(", ");
            }
            if (this.detailedErrorCode != null) {
                builder.append("detailedErrorCode=").append((Object)this.detailedErrorCode).append(", ");
            }
            if (this.itemId != null) {
                builder.append("itemId=").append(this.itemId).append(", ");
            }
            if (this.reason != null) {
                builder.append("reason=").append((Object)this.reason).append(", ");
            }
            if (this.type != null) {
                builder.append("type=").append((Object)this.type).append(", ");
            }
            builder.append("requestId=").append(this.requestId).append("]");
            return builder.toString();
        }
    }

    @Immutable
    public static class CloseResponse
    extends StandardResponse {
        protected CloseResponse(@JsonProperty(value="requestId") long requestId) {
            super(requestId);
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return CastEvent.CastEventType.CLOSE;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [requestId=" + this.getRequestId() + "]";
        }
    }

    @Immutable
    public static class PongResponse
    extends StandardResponse {
        protected PongResponse() {
            super(0L);
        }

        @Override
        @JsonIgnore
        public long getRequestId() {
            return super.getRequestId();
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [requestId=" + this.getRequestId() + "]";
        }
    }

    @Immutable
    public static class PingResponse
    extends StandardResponse {
        protected PingResponse(@JsonProperty(value="requestId") long requestId) {
            super(requestId);
        }

        @Override
        @JsonIgnore
        public CastEvent.CastEventType getEventType() {
            return null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [requestId=" + this.getRequestId() + "]";
        }
    }
}

