/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TextTrackStyle {
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String backgroundColor;
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final Map<String, Object> customData;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String edgeColor;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final TextTrackEdgeType edgeType;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String fontFamily;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final TextTrackFontGenericFamily fontGenericFamily;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Double fontScale;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final TextTrackFontStyle fontStyle;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String foregroundColor;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String windowColor;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Integer windowRoundedCornerRadius;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final TextTrackWindowType windowType;

    public TextTrackStyle(@Nullable String foregroundColor, @Nullable String backgroundColor, @Nullable TextTrackEdgeType edgeType, @Nullable String edgeColor, @Nullable String fontFamily, @Nullable TextTrackFontGenericFamily fontGenericFamily, @Nullable Double fontScale, @Nullable TextTrackFontStyle fontStyle) {
        this(backgroundColor, null, edgeColor, edgeType, fontFamily, fontGenericFamily, fontScale, fontStyle, foregroundColor, null, null, null);
    }

    public TextTrackStyle(@JsonProperty(value="backgroundColor") @Nullable String backgroundColor, @JsonProperty(value="customData") @Nullable Map<String, Object> customData, @JsonProperty(value="edgeColor") @Nullable String edgeColor, @JsonProperty(value="edgeType") @Nullable TextTrackEdgeType edgeType, @JsonProperty(value="fontFamily") @Nullable String fontFamily, @JsonProperty(value="fontGenericFamily") @Nullable TextTrackFontGenericFamily fontGenericFamily, @JsonProperty(value="fontScale") @Nullable Double fontScale, @JsonProperty(value="fontStyle") @Nullable TextTrackFontStyle fontStyle, @JsonProperty(value="foregroundColor") @Nullable String foregroundColor, @JsonProperty(value="windowColor") @Nullable String windowColor, @JsonProperty(value="windowRoundedCornerRadius") @Nullable Integer windowRoundedCornerRadius, @JsonProperty(value="windowType") @Nullable TextTrackWindowType windowType) {
        this.backgroundColor = backgroundColor;
        this.customData = customData == null || customData.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(customData));
        this.edgeColor = edgeColor;
        this.edgeType = edgeType;
        this.fontFamily = fontFamily;
        this.fontGenericFamily = fontGenericFamily;
        this.fontScale = fontScale;
        this.fontStyle = fontStyle;
        this.foregroundColor = foregroundColor;
        this.windowColor = windowColor;
        this.windowRoundedCornerRadius = windowRoundedCornerRadius;
        this.windowType = windowType;
    }

    @Nullable
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Nonnull
    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    @Nullable
    public String getEdgeColor() {
        return this.edgeColor;
    }

    @Nullable
    public TextTrackEdgeType getEdgeType() {
        return this.edgeType;
    }

    @Nullable
    public String getFontFamily() {
        return this.fontFamily;
    }

    @Nullable
    public TextTrackFontGenericFamily getFontGenericFamily() {
        return this.fontGenericFamily;
    }

    @Nullable
    public Double getFontScale() {
        return this.fontScale;
    }

    @Nullable
    public TextTrackFontStyle getFontStyle() {
        return this.fontStyle;
    }

    @Nullable
    public String getForegroundColor() {
        return this.foregroundColor;
    }

    @Nullable
    public String getWindowColor() {
        return this.windowColor;
    }

    @Nullable
    public Integer getWindowRoundedCornerRadius() {
        return this.windowRoundedCornerRadius;
    }

    @Nullable
    public TextTrackWindowType getWindowType() {
        return this.windowType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.backgroundColor, this.customData, this.edgeColor, this.edgeType, this.fontFamily, this.fontGenericFamily, this.fontScale, this.fontStyle, this.foregroundColor, this.windowColor, this.windowRoundedCornerRadius, this.windowType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle other = (TextTrackStyle)obj;
        return Objects.equals(this.backgroundColor, other.backgroundColor) && Objects.equals(this.customData, other.customData) && Objects.equals(this.edgeColor, other.edgeColor) && this.edgeType == other.edgeType && Objects.equals(this.fontFamily, other.fontFamily) && this.fontGenericFamily == other.fontGenericFamily && Objects.equals(this.fontScale, other.fontScale) && this.fontStyle == other.fontStyle && Objects.equals(this.foregroundColor, other.foregroundColor) && Objects.equals(this.windowColor, other.windowColor) && Objects.equals(this.windowRoundedCornerRadius, other.windowRoundedCornerRadius) && this.windowType == other.windowType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        if (this.backgroundColor != null) {
            builder.append("backgroundColor=").append(this.backgroundColor).append(", ");
        }
        if (this.customData != null) {
            builder.append("customData=").append(this.customData).append(", ");
        }
        if (this.edgeColor != null) {
            builder.append("edgeColor=").append(this.edgeColor).append(", ");
        }
        if (this.edgeType != null) {
            builder.append("edgeType=").append((Object)this.edgeType).append(", ");
        }
        if (this.fontFamily != null) {
            builder.append("fontFamily=").append(this.fontFamily).append(", ");
        }
        if (this.fontGenericFamily != null) {
            builder.append("fontGenericFamily=").append((Object)this.fontGenericFamily).append(", ");
        }
        if (this.fontScale != null) {
            builder.append("fontScale=").append(this.fontScale).append(", ");
        }
        if (this.fontStyle != null) {
            builder.append("fontStyle=").append((Object)this.fontStyle).append(", ");
        }
        if (this.foregroundColor != null) {
            builder.append("foregroundColor=").append(this.foregroundColor).append(", ");
        }
        if (this.windowColor != null) {
            builder.append("windowColor=").append(this.windowColor).append(", ");
        }
        if (this.windowRoundedCornerRadius != null) {
            builder.append("windowRoundedCornerRadius=").append(this.windowRoundedCornerRadius).append(", ");
        }
        if (this.windowType != null) {
            builder.append("windowType=").append((Object)this.windowType);
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum TextTrackWindowType {
        NONE,
        NORMAL,
        ROUNDED_CORNERS;

    }

    public static enum TextTrackFontStyle {
        NORMAL,
        BOLD,
        BOLD_ITALIC,
        ITALIC;

    }

    public static enum TextTrackFontGenericFamily {
        SANS_SERIF,
        MONOSPACED_SANS_SERIF,
        SERIF,
        MONOSPACED_SERIF,
        CASUAL,
        CURSIVE,
        SMALL_CAPITALS;

    }

    public static enum TextTrackEdgeType {
        NONE,
        OUTLINE,
        DROP_SHADOW,
        RAISED,
        DEPRESSED;

    }
}

