/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Track {
    public static final String CAPTION_MIME_TYPE_CEA608 = "CEA608";
    public static final String CAPTION_MIME_TYPE_TTML = "TTML";
    public static final String CAPTION_MIME_TYPE_VTT = "VTT";
    public static final String CAPTION_MIME_TYPE_TTML_MP4 = "TTML_MP4";
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final Map<String, Object> customData;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Boolean isInband;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String language;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String name;
    @Nonnull
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected final List<String> roles;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final TrackSubType subtype;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String trackContentId;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final String trackContentType;
    @JsonProperty
    protected final int trackId;
    @Nonnull
    @JsonProperty
    protected final TrackType type;

    public Track(@JsonProperty(value="customData") Map<String, Object> customData, @JsonProperty(value="isInband") Boolean isInband, @JsonProperty(value="language") String language, @JsonProperty(value="name") String name, @JsonProperty(value="roles") List<String> roles, @JsonProperty(value="subtype") TrackSubType subtype, @JsonProperty(value="trackContentId") String trackContentId, @JsonProperty(value="trackContentType") String trackContentType, @JsonProperty(value="trackId") int trackId, @Nonnull @JsonProperty(value="trackType") TrackType type) {
        this.customData = customData == null || customData.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<String, Object>(customData));
        this.isInband = isInband;
        this.language = language;
        this.name = name;
        this.roles = roles == null || roles.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(roles));
        this.subtype = subtype;
        this.trackContentId = trackContentId;
        this.trackContentType = trackContentType;
        this.trackId = trackId;
        this.type = type;
    }

    @Nonnull
    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    @Nullable
    public Boolean getIsInband() {
        return this.isInband;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nonnull
    public List<String> getRoles() {
        return this.roles;
    }

    @Nullable
    public TrackSubType getSubtype() {
        return this.subtype;
    }

    @Nullable
    public String getTrackContentId() {
        return this.trackContentId;
    }

    @Nullable
    public String getTrackContentType() {
        return this.trackContentType;
    }

    public int getTrackId() {
        return this.trackId;
    }

    @Nonnull
    public TrackType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customData, this.isInband, this.language, this.name, this.roles, this.subtype, this.trackContentId, this.trackContentType, this.trackId, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Track)) {
            return false;
        }
        Track other = (Track)obj;
        return Objects.equals(this.customData, other.customData) && Objects.equals(this.isInband, other.isInband) && Objects.equals(this.language, other.language) && Objects.equals(this.name, other.name) && Objects.equals(this.roles, other.roles) && Objects.equals((Object)this.subtype, (Object)other.subtype) && Objects.equals(this.trackContentId, other.trackContentId) && Objects.equals(this.trackContentType, other.trackContentType) && this.trackId == other.trackId && this.type == other.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        if (this.customData != null) {
            builder.append("customData=").append(this.customData).append(", ");
        }
        if (this.isInband != null) {
            builder.append("isInband=").append(this.isInband).append(", ");
        }
        if (this.language != null) {
            builder.append("language=").append(this.language).append(", ");
        }
        if (this.name != null) {
            builder.append("name=").append(this.name).append(", ");
        }
        if (this.roles != null) {
            builder.append("roles=").append(this.roles).append(", ");
        }
        if (this.subtype != null) {
            builder.append("subtype=").append((Object)this.subtype).append(", ");
        }
        if (this.trackContentId != null) {
            builder.append("trackContentId=").append(this.trackContentId).append(", ");
        }
        if (this.trackContentType != null) {
            builder.append("trackContentType=").append(this.trackContentType).append(", ");
        }
        builder.append("trackId=").append(this.trackId).append(", ");
        if (this.type != null) {
            builder.append("type=").append((Object)this.type);
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum TrackSubType {
        SUBTITLES,
        CAPTIONS,
        DESCRIPTIONS,
        CHAPTERS,
        METADATA;

    }

    public static enum TrackType {
        TEXT,
        AUDIO,
        VIDEO;

    }
}

