/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class Util {
    private Util() {
    }

    public static int intFromB32Bytes(byte[] payload) {
        return payload[0] << 24 | (payload[1] & 0xFF) << 16 | (payload[2] & 0xFF) << 8 | payload[3] & 0xFF;
    }

    public static byte[] intToB32Bytes(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static int writeB32Int(int value, @Nonnull OutputStream os) throws IOException {
        os.write(value >> 24);
        os.write(value >> 16);
        os.write(value >> 8);
        os.write(value);
        return 4;
    }

    public static int readB32Int(@Nonnull InputStream is) throws IOException {
        int result = 0;
        for (int i = 24; i >= 0; i -= 8) {
            int read = is.read();
            if (read < 0) {
                throw new IOException("Incorrect message length (" + (3 - i / 8) + " bytes)");
            }
            result |= (read & 0xFF) << i;
        }
        return result;
    }

    public static boolean isBlank(@Nullable CharSequence cs) {
        if (cs == null) {
            return true;
        }
        int strLen = cs.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void requireNotNull(@Nullable Object object, @Nonnull String objectName) {
        if (objectName == null) {
            throw new AssertionError((Object)"Invalid use of requireNotNull, objectName must be specified");
        }
        if (object == null) {
            throw new IllegalArgumentException(objectName + " cannot be null");
        }
    }

    public static void requireNotBlank(@Nullable CharSequence charSequence, @Nonnull String charSequenceName) {
        if (charSequenceName == null) {
            throw new AssertionError((Object)"Invalid use of requireNotBlank, charSequenceName must be specified");
        }
        if (charSequence == null || Util.isBlank(charSequence)) {
            throw new IllegalArgumentException(charSequenceName + " cannot be null or blank");
        }
    }
}

