/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.Util;

@Immutable
public class VideoInformation {
    @Nonnull
    @JsonProperty
    protected final HdrType hdrType;
    @JsonProperty
    protected int height;
    @JsonProperty
    protected int width;

    public VideoInformation(@JsonProperty(value="hdrType") HdrType hdrType, @JsonProperty(value="height") int height, @JsonProperty(value="width") int width) {
        Util.requireNotNull((Object)hdrType, "hdrType");
        this.hdrType = hdrType;
        this.height = height;
        this.width = width;
    }

    @Nonnull
    public HdrType getHdrType() {
        return this.hdrType;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hdrType, this.height, this.width});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VideoInformation)) {
            return false;
        }
        VideoInformation other = (VideoInformation)obj;
        return this.hdrType == other.hdrType && this.height == other.height && this.width == other.width;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [").append("hdrType=").append((Object)this.hdrType).append(", ").append("height=").append(this.height).append(", width=").append(this.width).append("]");
        return builder.toString();
    }

    public static enum HdrType {
        SDR,
        HDR,
        DV;


        @Nullable
        @JsonCreator
        public static HdrType typeOf(String hdrType) {
            if (Util.isBlank(hdrType)) {
                return null;
            }
            String typeString = hdrType.toUpperCase(Locale.ROOT);
            for (HdrType type : HdrType.values()) {
                if (!typeString.equals(type.name())) continue;
                return type;
            }
            return null;
        }
    }
}

