/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.cast;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.digitalmediaserver.cast.Util;

@Immutable
public class Volume {
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final VolumeControlType controlType;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Double level;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Boolean muted;
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected final Double stepInterval;

    public Volume(@JsonProperty(value="controlType") @Nullable VolumeControlType controlType, @JsonProperty(value="level") @Nullable Double level, @JsonProperty(value="muted") @Nullable Boolean muted, @JsonProperty(value="stepInterval") @Nullable Double stepInterval) {
        this.controlType = controlType;
        this.level = level;
        this.muted = muted;
        this.stepInterval = stepInterval;
    }

    @Nullable
    public VolumeControlType getControlType() {
        return this.controlType;
    }

    @Nullable
    public Double getLevel() {
        return this.level;
    }

    @Nullable
    public Boolean getMuted() {
        return this.muted;
    }

    @Nullable
    public Double getStepInterval() {
        return this.stepInterval;
    }

    @Nonnull
    public VolumeBuilder modify() {
        return new VolumeBuilder(this.controlType, this.stepInterval).level(this.level).muted(this.muted);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.controlType, this.level, this.muted, this.stepInterval});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)obj;
        return this.controlType == other.controlType && Objects.equals(this.level, other.level) && Objects.equals(this.muted, other.muted) && Objects.equals(this.stepInterval, other.stepInterval);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        builder.append("controlType=").append((Object)this.controlType).append(", ");
        if (this.level != null) {
            builder.append("level=").append(this.level).append(", ");
        }
        if (this.muted != null) {
            builder.append("muted=").append(this.muted).append(", ");
        }
        builder.append("stepInterval=").append(this.stepInterval);
        builder.append("]");
        return builder.toString();
    }

    public static enum VolumeControlType {
        ATTENUATION,
        FIXED,
        MASTER;


        @Nullable
        @JsonCreator
        public static VolumeControlType typeOf(String controlType) {
            if (Util.isBlank(controlType)) {
                return null;
            }
            String typeString = controlType.toUpperCase(Locale.ROOT);
            for (VolumeControlType type : VolumeControlType.values()) {
                if (!typeString.equals(type.name())) continue;
                return type;
            }
            return null;
        }
    }

    public static class VolumeBuilder {
        @Nullable
        protected VolumeControlType controlType;
        @Nullable
        protected Double level;
        @Nullable
        protected Boolean muted;
        @Nullable
        protected Double stepInterval;

        public VolumeBuilder(@Nullable VolumeControlType controlType, @Nullable Double stepInterval) {
            this.controlType = controlType;
            this.stepInterval = stepInterval;
        }

        @Nullable
        public VolumeControlType controlType() {
            return this.controlType;
        }

        @Nullable
        public Double level() {
            return this.level;
        }

        @Nonnull
        public VolumeBuilder level(@Nullable Double level) {
            this.level = level;
            return this;
        }

        @Nullable
        public Boolean muted() {
            return this.muted;
        }

        @Nonnull
        public VolumeBuilder muted(@Nullable Boolean muted) {
            this.muted = muted;
            return this;
        }

        @Nullable
        public Double stepInterval() {
            return this.stepInterval;
        }

        public Volume build() {
            return new Volume(this.controlType, this.level, this.muted, this.stepInterval);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName()).append(" [");
            if (this.controlType != null) {
                builder.append("controlType=").append((Object)this.controlType).append(", ");
            }
            if (this.level != null) {
                builder.append("level=").append(this.level).append(", ");
            }
            if (this.muted != null) {
                builder.append("muted=").append(this.muted).append(", ");
            }
            if (this.stepInterval != null) {
                builder.append("stepInterval=").append(this.stepInterval);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

