/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.configuration;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import org.digitalmediaserver.crowdin.configuration.AbstractFileSet;
import org.digitalmediaserver.crowdin.configuration.FileType;
import org.digitalmediaserver.crowdin.tool.CrowdinFileSystem;

public class StatusFile
extends AbstractFileSet {
    protected String targetFile;

    @Nullable
    public String getTargetFile() {
        return this.targetFile;
    }

    @Override
    protected void initializeInstance() throws MojoExecutionException {
        if (this.addComment == null) {
            this.addComment = Boolean.TRUE;
        }
        if (this.type == null) {
            String extension;
            int dot = this.targetFile.lastIndexOf(46);
            this.type = dot > 0 && dot < this.targetFile.length() - 1 ? ("xml".equals(extension = this.targetFile.substring(dot + 1).toLowerCase(Locale.ROOT)) ? FileType.xml : FileType.properties) : FileType.properties;
        }
        switch (this.type) {
            case properties: {
                if (AbstractCrowdinMojo.isBlank(this.encoding)) {
                    this.charset = StandardCharsets.ISO_8859_1;
                    this.encoding = this.charset.name();
                } else {
                    this.charset = Charset.forName(this.encoding);
                }
                if (this.sortLines == null) {
                    this.sortLines = Boolean.TRUE;
                }
                if (this.escapeUnicode != null) break;
                this.escapeUnicode = Boolean.TRUE;
                break;
            }
            case xml: {
                if (AbstractCrowdinMojo.isBlank(this.encoding)) {
                    this.charset = StandardCharsets.UTF_8;
                    this.encoding = this.charset.name();
                } else {
                    this.charset = Charset.forName(this.encoding);
                }
                if (this.sortLines == null) {
                    this.sortLines = Boolean.FALSE;
                }
                if (this.escapeUnicode != null) break;
                this.escapeUnicode = Boolean.FALSE;
                break;
            }
            default: {
                throw new MojoExecutionException("Only properties and XML formats are supported for status files");
            }
        }
        if (AbstractCrowdinMojo.isBlank(this.targetFile)) {
            throw new MojoExecutionException("\"targetFile\" must be specified for status files");
        }
        this.targetFile = CrowdinFileSystem.formatPath(this.targetFile, false);
        super.initializeInstance();
    }
}

