/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.configuration;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import org.digitalmediaserver.crowdin.configuration.AbstractFileSet;
import org.digitalmediaserver.crowdin.configuration.FileType;
import org.digitalmediaserver.crowdin.configuration.UpdateOption;
import org.digitalmediaserver.crowdin.tool.CrowdinFileSystem;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
public class TranslationFileSet
extends AbstractFileSet {
    protected File languageFilesFolder;
    protected String crowdinPath;
    protected String baseFileName;
    protected String title;
    protected String commentTag;
    protected String fileNameWhenExported;
    @Nullable
    protected String targetFileName;
    @Nullable
    protected Integer escapeQuotes;
    protected UpdateOption updateOption;
    @Nullable
    protected List<String> includes;
    @Nullable
    protected List<String> excludes;

    public String getCommentTag() {
        return this.commentTag;
    }

    public void setCommentTag(String commentTag) {
        this.commentTag = commentTag;
    }

    public File getLanguageFilesFolder() {
        return this.languageFilesFolder;
    }

    public String getCrowdinPath() {
        return this.crowdinPath;
    }

    public String getBaseFileName() {
        return this.baseFileName;
    }

    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public String getFileNameWhenExported() {
        return this.fileNameWhenExported;
    }

    @Nullable
    public String getTargetFileName() {
        return this.targetFileName;
    }

    @Nullable
    public Integer getEscapeQuotes() {
        return this.escapeQuotes;
    }

    public UpdateOption getUpdateOption() {
        return this.updateOption;
    }

    @Nullable
    public List<String> getIncludes() {
        return this.includes;
    }

    @Nullable
    public List<String> getExcludes() {
        return this.excludes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": \"" + this.title + "\"";
    }

    @Override
    protected void initializeInstance() throws MojoExecutionException {
        if (this.baseFileName != null) {
            this.baseFileName = CrowdinFileSystem.formatPath(this.baseFileName, false);
        }
        if (AbstractCrowdinMojo.isBlank(this.title)) {
            this.title = this.baseFileName;
        }
        if (AbstractCrowdinMojo.isBlank(this.baseFileName)) {
            if (AbstractCrowdinMojo.isBlank(this.title)) {
                throw new MojoExecutionException("\"baseFileName\" isn't defined for translation fileset");
            }
            throw new MojoExecutionException("\"baseFileName\" isn't defined for translation fileset \"" + this.title + "\"");
        }
        if (this.languageFilesFolder == null) {
            throw new MojoExecutionException("\"languageFilesFolder\" isn't defined for translation fileset \"" + this.title + "\"");
        }
        if (!this.languageFilesFolder.isDirectory()) {
            throw new MojoExecutionException("The specified folder \"" + this.languageFilesFolder.getAbsolutePath() + "\" for translation fileset \"" + this.title + "\" either doesn't exist or isn't a folder");
        }
        if (this.crowdinPath != null) {
            this.crowdinPath = CrowdinFileSystem.formatPath(this.crowdinPath, false);
        }
        if (this.type == null) {
            int dot = this.baseFileName.lastIndexOf(46);
            if (dot > 0 && dot < this.baseFileName.length() - 1) {
                String extension = this.baseFileName.substring(dot + 1);
                for (FileType fileType : FileType.values()) {
                    if (!fileType.hasExtension(extension)) continue;
                    this.type = fileType;
                    break;
                }
            }
            if (this.type == null) {
                this.type = FileType.auto;
            }
        }
        switch (this.type) {
            case properties: {
                if (AbstractCrowdinMojo.isBlank(this.encoding)) {
                    this.charset = StandardCharsets.ISO_8859_1;
                    this.encoding = this.charset.name();
                } else {
                    this.charset = Charset.forName(this.encoding);
                }
                if (this.sortLines == null) {
                    this.sortLines = Boolean.TRUE;
                }
                if (this.escapeUnicode != null) break;
                this.escapeUnicode = Boolean.TRUE;
                break;
            }
            case xml: {
                this.charset = StandardCharsets.UTF_8;
                this.encoding = this.charset.name();
                break;
            }
            default: {
                if (!AbstractCrowdinMojo.isBlank(this.encoding)) {
                    this.charset = Charset.forName(this.encoding);
                    break;
                }
                this.charset = StandardCharsets.UTF_8;
                this.encoding = this.charset.name();
            }
        }
        if (this.sortLines == null) {
            this.sortLines = Boolean.FALSE;
        }
        if (this.addComment == null) {
            this.addComment = Boolean.TRUE;
        }
        if (this.commentTag == null) {
            this.commentTag = "#";
        }
        if (AbstractCrowdinMojo.isBlank(this.fileNameWhenExported)) {
            throw new MojoExecutionException("\"fileNameWhenExported\" isn't defined for translation fileset \"" + this.title + "\"");
        }
        if (this.escapeQuotes != null && (this.escapeQuotes < 0 || this.escapeQuotes > 3)) {
            throw new MojoExecutionException("Invalid \"escapeQuotes\" value " + this.escapeQuotes + " for translation fileset \"" + this.title + "\"");
        }
        if (this.targetFileName != null) {
            this.targetFileName = CrowdinFileSystem.formatPath(this.targetFileName, false);
        }
        super.initializeInstance();
    }
}

