/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.tool;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;

public class GitUtil {
    private GitUtil() {
    }

    public static String getBranch(@Nonnull File projectBasedir, Log logger) throws MojoExecutionException {
        if (!projectBasedir.exists()) {
            if (logger != null) {
                logger.warn((CharSequence)("Project basedir (" + projectBasedir + ") doesn't exist - cannot determine git branch"));
            }
            return null;
        }
        if (!projectBasedir.isDirectory()) {
            if (logger != null) {
                logger.warn((CharSequence)("Project basedir (" + projectBasedir + ") must be a folder - cannot determine git branch"));
            }
            return null;
        }
        try {
            if (logger != null) {
                logger.debug((CharSequence)("Trying to read \"" + projectBasedir + "\" with git"));
            }
            Git git = Git.open((File)projectBasedir);
            Repository repo = git.getRepository();
            try {
                String branch = repo.getBranch();
                if (repo.getRef("HEAD").getTarget().getName().endsWith(branch)) {
                    if (logger != null) {
                        logger.debug((CharSequence)("Git branch determined to be \"" + branch + "\""));
                    }
                    return branch;
                }
                if (logger != null) {
                    logger.error((CharSequence)("Git branch was reported to be \"" + branch + "\" which means that HEAD is detached"));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while reading git branch: " + e.getMessage(), (Exception)e);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while opening project basedir with git: " + e.getMessage(), (Exception)e);
        }
        if (logger != null) {
            logger.error((CharSequence)"Can't determine git branch");
        }
        return null;
    }
}

