/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource.loc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.diirt.datasource.ChannelHandlerReadSubscription;
import org.diirt.datasource.ChannelHandlerWriteSubscription;
import org.diirt.datasource.ChannelWriteCallback;
import org.diirt.datasource.MultiplexedChannelHandler;
import org.diirt.vtype.Alarm;
import org.diirt.vtype.Time;
import org.diirt.vtype.VDouble;
import org.diirt.vtype.VDoubleArray;
import org.diirt.vtype.VEnum;
import org.diirt.vtype.VString;
import org.diirt.vtype.VStringArray;
import org.diirt.vtype.VTable;
import org.diirt.vtype.VType;
import org.diirt.vtype.ValueFactory;

class LocalChannelHandler
extends MultiplexedChannelHandler<Object, Object> {
    private static Logger log = Logger.getLogger(LocalChannelHandler.class.getName());
    private Object initialArguments;
    private Object initialValue;
    private Class<?> type;

    LocalChannelHandler(String channelName) {
        super(channelName);
    }

    public void connect() {
        this.processConnection(new Object());
    }

    public void disconnect() {
        this.initialArguments = null;
        this.type = null;
        this.processConnection(null);
    }

    protected synchronized void addReader(ChannelHandlerReadSubscription subscription) {
        super.addReader(subscription);
    }

    protected synchronized void addWriter(ChannelHandlerWriteSubscription subscription) {
        super.addWriter(subscription);
    }

    protected synchronized void removeReader(ChannelHandlerReadSubscription subscription) {
        super.removeReader(subscription);
    }

    protected synchronized void removeWrite(ChannelHandlerWriteSubscription subscription) {
        super.removeWrite(subscription);
    }

    private Object checkValue(Object value) {
        if (this.type != null && !this.type.isInstance(value)) {
            throw new IllegalArgumentException("Value " + value + " is not of type " + this.type.getSimpleName());
        }
        return value;
    }

    public void write(Object newValue, ChannelWriteCallback callback) {
        try {
            if (VEnum.class.equals(this.type)) {
                int newIndex = -1;
                VEnum firstEnum = (VEnum)this.initialValue;
                List labels = firstEnum.getLabels();
                if (newValue instanceof Number) {
                    newIndex = ((Number)newValue).intValue();
                } else if (newValue instanceof String) {
                    newIndex = labels.indexOf((String)newValue);
                    if (newIndex == -1) {
                        String value = (String)newValue;
                        try {
                            newIndex = Double.valueOf(value).intValue();
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else {
                    throw new IllegalArgumentException("Value" + newValue + " can not be accepted by VEnum.");
                }
                newValue = ValueFactory.newVEnum((int)newIndex, (List)firstEnum.getLabels(), (Alarm)ValueFactory.alarmNone(), (Time)ValueFactory.timeNow());
            } else if (VString.class.equals(this.type) && newValue instanceof String) {
                newValue = ValueFactory.newVString((String)((String)newValue), (Alarm)ValueFactory.alarmNone(), (Time)ValueFactory.timeNow());
            } else {
                if (newValue instanceof String) {
                    String value = (String)newValue;
                    try {
                        newValue = Double.valueOf(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!(newValue instanceof VType)) {
                    newValue = this.checkValue(ValueFactory.toVTypeChecked((Object)newValue));
                }
            }
            this.processMessage(newValue);
            callback.channelWritten(null);
        }
        catch (Exception ex) {
            callback.channelWritten(ex);
        }
    }

    protected boolean isWriteConnected(Object payload) {
        return this.isConnected(payload);
    }

    synchronized void setInitialValue(Object value) {
        if (this.initialArguments != null && !this.initialArguments.equals(value)) {
            String message = "Different initialization for local channel " + this.getChannelName() + ": " + value + " but was " + this.initialArguments;
            log.log(Level.WARNING, message);
            throw new RuntimeException(message);
        }
        this.initialArguments = value;
        if (this.getLastMessagePayload() == null) {
            if (VEnum.class.equals(this.type)) {
                List args = (List)this.initialArguments;
                int index = ((Number)args.get(0)).intValue();
                List labels = (List)args.get(1);
                this.initialValue = ValueFactory.newVEnum((int)index, (List)labels, (Alarm)ValueFactory.alarmNone(), (Time)ValueFactory.timeNow());
            } else {
                this.initialValue = this.checkValue(ValueFactory.toVTypeChecked((Object)value));
            }
            this.processMessage(this.initialValue);
        }
    }

    synchronized void setType(String typeName) {
        if (typeName == null) {
            return;
        }
        Class<VDouble> newType = null;
        if ("VDouble".equals(typeName)) {
            newType = VDouble.class;
        }
        if ("VString".equals(typeName)) {
            newType = VString.class;
        }
        if ("VDoubleArray".equals(typeName)) {
            newType = VDoubleArray.class;
        }
        if ("VStringArray".equals(typeName)) {
            newType = VStringArray.class;
        }
        if ("VTable".equals(typeName)) {
            newType = VTable.class;
        }
        if ("VEnum".equals(typeName)) {
            newType = VEnum.class;
        }
        if (newType == null) {
            throw new IllegalArgumentException("Type " + typeName + " for channel " + this.getChannelName() + " is not supported by local datasource.");
        }
        if (this.type != null && !this.type.equals(newType)) {
            throw new IllegalArgumentException("Type mismatch for channel " + this.getChannelName() + ": " + typeName + " but was " + this.type.getSimpleName());
        }
        this.type = newType;
    }

    public synchronized Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("Name", this.getChannelName());
        properties.put("Type", this.type);
        properties.put("Initial Value", this.initialArguments);
        return properties;
    }
}

