/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource.loc;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.diirt.datasource.ChannelHandler;
import org.diirt.datasource.ChannelReadRecipe;
import org.diirt.datasource.ChannelWriteRecipe;
import org.diirt.datasource.DataSource;
import org.diirt.datasource.ReadRecipe;
import org.diirt.datasource.WriteRecipe;
import org.diirt.datasource.loc.LocalChannelHandler;
import org.diirt.datasource.util.FunctionParser;
import org.diirt.datasource.vtype.DataTypeSupport;

public class LocalDataSource
extends DataSource {
    private final boolean zeroInitialization;

    public LocalDataSource() {
        this(false);
    }

    @Deprecated
    public LocalDataSource(boolean zeroInitialization) {
        super(true);
        this.zeroInitialization = zeroInitialization;
    }

    protected ChannelHandler createChannel(String channelName) {
        List<Object> parsedTokens = this.parseName(channelName);
        LocalChannelHandler channel = new LocalChannelHandler(parsedTokens.get(0).toString());
        return channel;
    }

    private List<Object> parseName(String channelName) {
        ArrayList<Object> initialValue;
        String nameAndType;
        List tokens = FunctionParser.parseFunctionAnyParameter((String)".+", (String)channelName);
        String name = nameAndType = tokens.get(0).toString();
        String type = null;
        int index = nameAndType.lastIndexOf(60);
        if (nameAndType.endsWith(">") && index != -1) {
            name = nameAndType.substring(0, index);
            type = nameAndType.substring(index + 1, nameAndType.length() - 1);
        }
        ArrayList<Object> newTokens = new ArrayList<Object>();
        newTokens.add(name);
        newTokens.add(type);
        if ("VEnum".equals(type)) {
            ArrayList<Object> initialValueList = new ArrayList<Object>();
            initialValueList.add(tokens.remove(1));
            Object labels = FunctionParser.asScalarOrList(tokens.subList(1, tokens.size()));
            if (!(labels instanceof List)) {
                throw new RuntimeException("Invalid format for VEnum channel.");
            }
            initialValueList.add(labels);
            initialValue = initialValueList;
        } else {
            initialValue = FunctionParser.asScalarOrList(tokens.subList(1, tokens.size()));
        }
        if (tokens.size() > 1) {
            newTokens.add(initialValue);
        }
        return newTokens;
    }

    protected String channelHandlerLookupName(String channelName) {
        List<Object> parsedTokens = this.parseName(channelName);
        return parsedTokens.get(0).toString();
    }

    private void initialize(String channelName) {
        List<Object> parsedTokens = this.parseName(channelName);
        LocalChannelHandler channel = (LocalChannelHandler)((Object)this.getChannels().get(this.channelHandlerLookupName(channelName)));
        channel.setType((String)parsedTokens.get(1));
        if (parsedTokens.size() > 2) {
            if (channel != null) {
                channel.setInitialValue(parsedTokens.get(2));
            }
        } else if (this.zeroInitialization) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).warning("Using zero initialization for channel " + channelName);
            channel.setInitialValue(0);
        }
    }

    public void connectRead(ReadRecipe readRecipe) {
        super.connectRead(readRecipe);
        for (ChannelReadRecipe channelReadRecipe : readRecipe.getChannelReadRecipes()) {
            this.initialize(channelReadRecipe.getChannelName());
        }
    }

    public void connectWrite(WriteRecipe writeRecipe) {
        super.connectWrite(writeRecipe);
        for (ChannelWriteRecipe channelWriteRecipe : writeRecipe.getChannelWriteRecipes()) {
            this.initialize(channelWriteRecipe.getChannelName());
        }
    }

    static {
        DataTypeSupport.install();
    }
}

