/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource;

import org.diirt.datasource.ChannelReadRecipe;
import org.diirt.datasource.PVDirector;
import org.diirt.datasource.ReadFunction;
import org.diirt.datasource.ReadRecipe;
import org.diirt.datasource.ValueCache;
import org.diirt.datasource.expression.DesiredRateExpression;

public class ReadExpressionTester {
    private DesiredRateExpression<?> expression;
    private ReadRecipe readRecipe;
    private PVDirector<?> pvReaderDirector = new PVDirector(null, null, null, null, null, null);

    public ReadExpressionTester(DesiredRateExpression<?> expression) {
        this.expression = expression;
        this.pvReaderDirector.connectReadExpression(expression);
    }

    public ReadRecipe getCurrentReadRecipe() {
        return this.pvReaderDirector.getCurrentReadRecipe();
    }

    public void writeValue(String name, Object value) {
        boolean written = false;
        for (ChannelReadRecipe channelRecipe : this.getCurrentReadRecipe().getChannelReadRecipes()) {
            if (!channelRecipe.getChannelName().equals(name)) continue;
            ValueCache cache = channelRecipe.getReadSubscription().getValueCache();
            cache.writeValue(value);
            written = true;
        }
        if (!written) {
            throw new IllegalStateException("Can't find recipe for channel '" + name + "'");
        }
    }

    public ChannelReadRecipe recipeFor(String channelName) {
        for (ChannelReadRecipe channelRecipe : this.getCurrentReadRecipe().getChannelReadRecipes()) {
            if (!channelRecipe.getChannelName().equals(channelName)) continue;
            return channelRecipe;
        }
        return null;
    }

    public ReadRecipe getReadRecipe() {
        return this.getCurrentReadRecipe();
    }

    public ReadFunction<?> getFunction() {
        return this.expression.getFunction();
    }

    public DesiredRateExpression<?> getExpression() {
        return this.expression;
    }

    public Object getValue() {
        return this.expression.getFunction().readValue();
    }
}

