/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource.test;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.diirt.datasource.ChannelHandler;
import org.diirt.datasource.ChannelReadRecipe;
import org.diirt.datasource.ChannelWriteRecipe;
import org.diirt.datasource.DataSource;
import org.diirt.datasource.ExceptionHandler;
import org.diirt.datasource.ReadRecipe;
import org.diirt.datasource.WriteRecipe;

public class MockDataSource
extends DataSource {
    private final List<ChannelReadRecipe> connectedReadRecipes = new CopyOnWriteArrayList<ChannelReadRecipe>();
    private final List<ChannelWriteRecipe> connectedWriteRecipes = new CopyOnWriteArrayList<ChannelWriteRecipe>();
    private volatile ReadRecipe readRecipe;
    private volatile WriteRecipe writeRecipe;
    private volatile WriteRecipe writeRecipeForWrite;

    public MockDataSource() {
        super(true);
    }

    protected ChannelHandler createChannel(String channelName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void connectRead(ReadRecipe recipe) {
        this.readRecipe = recipe;
        this.connectedReadRecipes.addAll(recipe.getChannelReadRecipes());
    }

    public void disconnectRead(ReadRecipe recipe) {
        this.readRecipe = recipe;
        this.connectedReadRecipes.removeAll(recipe.getChannelReadRecipes());
    }

    public void connectWrite(WriteRecipe writeRecipe) {
        this.writeRecipe = writeRecipe;
        this.connectedWriteRecipes.addAll(writeRecipe.getChannelWriteRecipes());
    }

    public void disconnectWrite(WriteRecipe writeRecipe) {
        this.writeRecipe = writeRecipe;
        this.connectedWriteRecipes.removeAll(writeRecipe.getChannelWriteRecipes());
    }

    public void write(WriteRecipe writeRecipe, Runnable callback, ExceptionHandler exceptionHandler) {
        this.writeRecipeForWrite = writeRecipe;
    }

    public ReadRecipe getReadRecipe() {
        return this.readRecipe;
    }

    public WriteRecipe getWriteRecipe() {
        return this.writeRecipe;
    }

    public WriteRecipe getWriteRecipeForWrite() {
        return this.writeRecipeForWrite;
    }

    public List<ChannelReadRecipe> getConnectedReadRecipes() {
        return this.connectedReadRecipes;
    }

    public List<ChannelWriteRecipe> getConnectedWriteRecipes() {
        return this.connectedWriteRecipes;
    }
}

