/*
 * Decompiled with CFR 0.152.
 */
package org.diirt.datasource.test;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import org.diirt.datasource.PVReader;
import org.diirt.util.time.TimeInterval;

public class ThreadTestingUtil {
    public static <T> T waitFor(Callable<T> task, Duration timeout) throws Exception {
        TimeInterval runInterval = TimeInterval.after((Duration)timeout, (Instant)Instant.now());
        while (runInterval.contains(Instant.now())) {
            T value = task.call();
            if (value != null) {
                return value;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    public static Duration waitForValue(PVReader<?> pvReader, Duration timeout) {
        TimeInterval runInterval = TimeInterval.after((Duration)timeout, (Instant)Instant.now());
        while (runInterval.contains(Instant.now())) {
            if (pvReader.getValue() != null) {
                return Duration.between(runInterval.getStart(), Instant.now());
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }
}

