/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.dwrp.ArrayOutboundVariable;
import org.directwebremoting.dwrp.ErrorOutboundVariable;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.Logger;

public class ArrayConverter
extends BaseV20Converter
implements Converter {
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$convert$ArrayConverter == null ? (class$org$directwebremoting$convert$ArrayConverter = ArrayConverter.class$("org.directwebremoting.convert.ArrayConverter")) : class$org$directwebremoting$convert$ArrayConverter);
    private ConverterManager converterManager = null;
    static /* synthetic */ Class class$org$directwebremoting$convert$ArrayConverter;

    public void setConverterManager(ConverterManager newConfig) {
        this.converterManager = newConfig;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws MarshallException {
        if (!paramType.isArray()) {
            throw new MarshallException(paramType);
        }
        String value = iv.getValue();
        if (value.startsWith("[")) {
            value = value.substring(1);
        }
        if (value.endsWith("]")) {
            value = value.substring(0, value.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        int size = st.countTokens();
        Class<?> componentType = paramType.getComponentType();
        Object array = Array.newInstance(componentType, size);
        inctx.addConverted(iv, paramType, array);
        InboundContext incx = iv.getLookup();
        for (int i = 0; i < size; ++i) {
            String token = st.nextToken();
            String[] split = ParseUtil.splitInbound(token);
            String splitType = split[0];
            String splitValue = split[1];
            InboundVariable nested = new InboundVariable(incx, null, splitType, splitValue);
            Object output = this.converterManager.convertInbound(componentType, nested, inctx, inctx.getCurrentTypeHintContext());
            Array.set(array, i, output);
        }
        return array;
    }

    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        if (!data.getClass().isArray()) {
            throw new MarshallException(data.getClass());
        }
        ArrayOutboundVariable ov = new ArrayOutboundVariable(outctx);
        outctx.put(data, ov);
        int size = Array.getLength(data);
        ArrayList<OutboundVariable> ovs = new ArrayList<OutboundVariable>();
        for (int i = 0; i < size; ++i) {
            OutboundVariable nested;
            try {
                nested = this.converterManager.convertOutbound(Array.get(data, i), outctx);
            }
            catch (Exception ex) {
                String errorMessage = "Conversion error for " + data.getClass().getName() + ".";
                log.warn(errorMessage, ex);
                nested = new ErrorOutboundVariable(outctx, errorMessage, true);
            }
            ovs.add(nested);
        }
        ov.init(ovs);
        return ov;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

