/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.dwrp.Sleeper;
import org.directwebremoting.dwrp.ThreadWaitSleeper;
import org.directwebremoting.util.Continuation;

public class JettyContinuationSleeper
implements Sleeper {
    private Object wakeUpCalledLock = new Object();
    private boolean wakeUpCalled = false;
    private ThreadWaitSleeper proxy = null;
    private Runnable onAwakening;
    protected final Continuation continuation;
    protected boolean resumed = false;
    public static final String ATTRIBUTE_JETTY_CONDUIT = "org.directwebremoting.dwrp.notifyConduit";
    private static final Log log = LogFactory.getLog((Class)(class$org$directwebremoting$dwrp$JettyContinuationSleeper == null ? (class$org$directwebremoting$dwrp$JettyContinuationSleeper = JettyContinuationSleeper.class$("org.directwebremoting.dwrp.JettyContinuationSleeper")) : class$org$directwebremoting$dwrp$JettyContinuationSleeper));
    static /* synthetic */ Class class$org$directwebremoting$dwrp$JettyContinuationSleeper;

    public JettyContinuationSleeper(HttpServletRequest request) {
        this.continuation = new Continuation(request);
        request.setAttribute(ATTRIBUTE_JETTY_CONDUIT, (Object)this);
    }

    public static boolean isRestart(HttpServletRequest request) {
        return request.getAttribute(ATTRIBUTE_JETTY_CONDUIT) != null;
    }

    public static void restart(HttpServletRequest request) {
        JettyContinuationSleeper sleeper = (JettyContinuationSleeper)request.getAttribute(ATTRIBUTE_JETTY_CONDUIT);
        if (sleeper == null) {
            throw new IllegalStateException("No JettyContinuationSleeper in HttpServletRequest");
        }
        request.removeAttribute(ATTRIBUTE_JETTY_CONDUIT);
        sleeper.onAwakening.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goToSleep(Runnable awakening) {
        this.onAwakening = awakening;
        Object object = this.wakeUpCalledLock;
        synchronized (object) {
            if (this.wakeUpCalled) {
                this.onAwakening.run();
            } else {
                try {
                    this.continuation.suspend(Integer.MAX_VALUE);
                }
                catch (Exception ex) {
                    Continuation.rethrowIfContinuation(ex);
                    log.warn((Object)"Exception", (Throwable)ex);
                    this.proxy = new ThreadWaitSleeper();
                    this.proxy.goToSleep(this.onAwakening);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        Object object = this.wakeUpCalledLock;
        synchronized (object) {
            if (this.wakeUpCalled) {
                return;
            }
            this.wakeUpCalled = true;
            if (this.proxy != null) {
                this.proxy.wakeUp();
            } else {
                Continuation continuation = this.continuation;
                synchronized (continuation) {
                    if (!this.resumed) {
                        try {
                            this.continuation.resume();
                        }
                        catch (Exception ex) {
                            log.error((Object)"Broken reflection", (Throwable)ex);
                        }
                        this.resumed = true;
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

