/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.impl.DefaultScriptSession;
import org.directwebremoting.util.Logger;

public class DefaultScriptSessionManager
implements ScriptSessionManager {
    protected static final long DEFAULT_SESSION_CHECK_TIME = 30000L;
    protected PageNormalizer pageNormalizer;
    protected volatile long scriptSessionTimeout = 300000L;
    protected volatile long scriptSessionCheckTime = 30000L;
    protected volatile long lastSessionCheckAt = System.currentTimeMillis();
    protected Map sessionMap = new HashMap();
    protected Map sessionPageMap = new HashMap();
    protected Map pageSessionMap = new HashMap();
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$impl$DefaultScriptSessionManager == null ? (class$org$directwebremoting$impl$DefaultScriptSessionManager = DefaultScriptSessionManager.class$("org.directwebremoting.impl.DefaultScriptSessionManager")) : class$org$directwebremoting$impl$DefaultScriptSessionManager);
    static /* synthetic */ Class class$org$directwebremoting$impl$DefaultScriptSessionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealScriptSession getScriptSession(String id) {
        this.maybeCheckTimeouts();
        Map map = this.sessionMap;
        synchronized (map) {
            DefaultScriptSession scriptSession = (DefaultScriptSession)this.sessionMap.get(id);
            if (scriptSession == null) {
                scriptSession = new DefaultScriptSession(id, this);
                this.sessionMap.put(id, scriptSession);
            } else {
                scriptSession.updateLastAccessedTime();
            }
            return scriptSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPageForScriptSession(RealScriptSession scriptSession, String page) {
        String normalizedPage = this.pageNormalizer.normalizePage(page);
        Map map = this.pageSessionMap;
        synchronized (map) {
            HashSet<RealScriptSession> pageSessions = (HashSet<RealScriptSession>)this.pageSessionMap.get(normalizedPage);
            if (pageSessions == null) {
                pageSessions = new HashSet<RealScriptSession>();
                this.pageSessionMap.put(normalizedPage, pageSessions);
            }
            HashSet<RealScriptSession> hashSet = pageSessions;
            synchronized (hashSet) {
                if (!pageSessions.contains(scriptSession)) {
                    pageSessions.add(scriptSession);
                }
            }
        }
        map = this.sessionPageMap;
        synchronized (map) {
            String currentPage = (String)this.sessionPageMap.get(scriptSession.getId());
            if (currentPage == null || !currentPage.equals(normalizedPage)) {
                this.sessionPageMap.put(scriptSession.getId(), normalizedPage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getScriptSessionsByPage(String page) {
        String normalizedPage = this.pageNormalizer.normalizePage(page);
        Map map = this.pageSessionMap;
        synchronized (map) {
            HashSet pageSessions = (HashSet)this.pageSessionMap.get(normalizedPage);
            if (pageSessions == null) {
                pageSessions = new HashSet();
            }
            HashSet reply = new HashSet();
            HashSet hashSet = pageSessions;
            synchronized (hashSet) {
                reply.addAll(pageSessions);
            }
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllScriptSessions() {
        Map map = this.sessionMap;
        synchronized (map) {
            HashSet reply = new HashSet();
            reply.addAll(this.sessionMap.values());
            return reply;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidate(RealScriptSession scriptSession) {
        Map map = this.sessionMap;
        synchronized (map) {
            RealScriptSession removed = (RealScriptSession)this.sessionMap.remove(scriptSession.getId());
            if (!scriptSession.equals(removed)) {
                log.debug("ScriptSession already removed from manager. scriptSession=" + scriptSession + " removed=" + removed);
            }
        }
        String page = null;
        Map map2 = this.sessionPageMap;
        synchronized (map2) {
            page = (String)this.sessionPageMap.remove(scriptSession.getId());
        }
        map2 = this.pageSessionMap;
        synchronized (map2) {
            Set pageSessions = (Set)this.pageSessionMap.get(page);
            if (pageSessions != null) {
                Set set = pageSessions;
                synchronized (set) {
                    pageSessions.remove(scriptSession);
                    if (pageSessions.isEmpty()) {
                        this.pageSessionMap.remove(page);
                    }
                }
            }
        }
    }

    protected void maybeCheckTimeouts() {
        long now = System.currentTimeMillis();
        if (now - this.scriptSessionCheckTime > this.lastSessionCheckAt) {
            this.checkTimeouts();
            this.lastSessionCheckAt = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        HashSet scriptSessions;
        long now = System.currentTimeMillis();
        Map map = this.sessionMap;
        synchronized (map) {
            scriptSessions = new HashSet(this.sessionMap.values());
        }
        Iterator it = scriptSessions.iterator();
        while (it.hasNext()) {
            long age;
            DefaultScriptSession session = (DefaultScriptSession)it.next();
            if (session.isInvalidated() || (age = now - session.getLastAccessedTime()) <= this.scriptSessionTimeout) continue;
            session.invalidate();
        }
    }

    public long getScriptSessionTimeout() {
        return this.scriptSessionTimeout;
    }

    public void setScriptSessionTimeout(long timeout) {
        this.scriptSessionTimeout = timeout;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionCheckTime(long scriptSessionCheckTime) {
        this.scriptSessionCheckTime = scriptSessionCheckTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

