/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.Container;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.InitializingBean;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.util.IdGenerator;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Logger;

public class FileHandler
implements Handler,
InitializingBean {
    private String overridePath = null;
    private boolean allowGetForSafariButMakeForgeryEasier = false;
    private String scriptTagProtection = "throw 'allowScriptTagRemoting is false.';";
    protected boolean ignoreLastModified = false;
    protected int maxWaitAfterWrite = -1;
    protected String sessionCookieName = "JSESSIONID";
    protected int compressionLevel = 7;
    protected boolean scriptCompressed = false;
    protected IdGenerator generator = new IdGenerator();
    protected int pageIdLength = 16;
    protected final Map scriptCache = new HashMap();
    private String filePath;
    private String mimeType;
    private boolean dynamic;
    private String pollWithXhr;
    private static final long servletContainerStartTime;
    private static final String etag;
    protected static final String PARAM_SCRIPT_ALLOWGET = "${allowGetForSafariButMakeForgeryEasier}";
    protected static final String PARAM_SCRIPT_POLLXHR = "${pollWithXhr}";
    protected static final String PARAM_SCRIPT_SESSIONID = "${scriptSessionId}";
    protected static final String PARAM_SCRIPT_COOKIENAME = "${sessionCookieName}";
    protected static final String PARAM_SCRIPT_TAG_PROTECTION = "${scriptTagProtection}";
    protected static final String PARAM_DEFAULT_PATH = "${defaultPath}";
    private static final Logger log;
    static /* synthetic */ Class class$org$directwebremoting$extend$ServerLoadMonitor;
    static /* synthetic */ Class class$org$directwebremoting$servlet$FileHandler;

    public FileHandler(String filePath, String mimeType, boolean dynamic) {
        this.filePath = filePath;
        this.mimeType = mimeType;
        this.dynamic = dynamic;
    }

    public FileHandler() {
    }

    public void afterContainerSetup(Container container) {
        if (this.dynamic) {
            ServerLoadMonitor monitor;
            boolean streaming = true;
            if (this.maxWaitAfterWrite > -1 && this.maxWaitAfterWrite < 500) {
                streaming = false;
            }
            if (!(monitor = (ServerLoadMonitor)container.getBean((class$org$directwebremoting$extend$ServerLoadMonitor == null ? (class$org$directwebremoting$extend$ServerLoadMonitor = FileHandler.class$("org.directwebremoting.extend.ServerLoadMonitor")) : class$org$directwebremoting$extend$ServerLoadMonitor).getName())).supportsStreaming()) {
                streaming = false;
            }
            this.pollWithXhr = streaming ? "false" : "true";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String output;
        block19: {
            if (this.dynamic) {
                response.setHeader("pragma", "public");
                response.setHeader("Expires", "0");
                response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            }
            if (!this.dynamic && this.isUpToDate(request)) {
                response.setStatus(304);
                return;
            }
            Map map = this.scriptCache;
            synchronized (map) {
                output = (String)this.scriptCache.get(this.filePath);
                if (output != null) break block19;
                StringBuffer buffer = new StringBuffer();
                String resource = "/org/directwebremoting" + this.filePath;
                InputStream raw = this.getClass().getResourceAsStream(resource);
                if (raw == null) {
                    throw new IOException("Failed to find resource: " + resource);
                }
                BufferedReader in = null;
                try {
                    String line;
                    in = new BufferedReader(new InputStreamReader(raw));
                    while ((line = in.readLine()) != null) {
                        if (this.dynamic) {
                            if (line.indexOf(PARAM_SCRIPT_COOKIENAME) != -1) {
                                line = LocalUtil.replace(line, PARAM_SCRIPT_COOKIENAME, this.sessionCookieName);
                            }
                            if (line.indexOf(PARAM_SCRIPT_POLLXHR) != -1) {
                                line = LocalUtil.replace(line, PARAM_SCRIPT_POLLXHR, this.pollWithXhr);
                            }
                            if (line.indexOf(PARAM_SCRIPT_SESSIONID) != -1) {
                                line = LocalUtil.replace(line, PARAM_SCRIPT_SESSIONID, this.generator.generateId(this.pageIdLength));
                            }
                            if (line.indexOf(PARAM_SCRIPT_ALLOWGET) != -1) {
                                line = LocalUtil.replace(line, PARAM_SCRIPT_ALLOWGET, String.valueOf(this.allowGetForSafariButMakeForgeryEasier));
                            }
                            if (line.indexOf(PARAM_SCRIPT_TAG_PROTECTION) != -1) {
                                line = LocalUtil.replace(line, PARAM_SCRIPT_TAG_PROTECTION, this.scriptTagProtection);
                            }
                            if (line.indexOf(PARAM_DEFAULT_PATH) != -1) {
                                String path = request.getContextPath() + request.getServletPath();
                                if (this.overridePath != null) {
                                    path = this.overridePath;
                                }
                                line = LocalUtil.replace(line, PARAM_DEFAULT_PATH, path);
                            }
                        }
                        buffer.append(line);
                        buffer.append('\n');
                    }
                }
                catch (Throwable throwable) {
                    LocalUtil.close(in);
                    throw throwable;
                }
                LocalUtil.close(in);
                output = buffer.toString();
                if (this.mimeType.equals("text/javascript; charset=utf-8") && this.scriptCompressed) {
                    output = JavascriptUtil.compress(output, this.compressionLevel);
                }
                if (!this.dynamic) {
                    this.scriptCache.put(this.filePath, output);
                }
            }
        }
        response.setContentType(this.mimeType);
        response.setDateHeader("Last-Modified", servletContainerStartTime);
        response.setHeader("ETag", etag);
        PrintWriter out = response.getWriter();
        out.println(output);
    }

    private boolean isUpToDate(HttpServletRequest req) {
        String givenEtag;
        if (this.ignoreLastModified) {
            return false;
        }
        long modifiedSince = -1L;
        try {
            modifiedSince = req.getDateHeader("If-Modified-Since");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        if (modifiedSince != -1L) {
            modifiedSince -= modifiedSince % 1000L;
        }
        if ((givenEtag = req.getHeader("If-None-Match")) == null) {
            if (modifiedSince >= servletContainerStartTime) {
                if (log.isDebugEnabled()) {
                    log.debug("Sending 304 for " + this.filePath + " If-Modified-Since=" + modifiedSince + ", Last-Modified=" + servletContainerStartTime);
                }
                return true;
            }
            return false;
        }
        if (modifiedSince == -1L) {
            if (!etag.equals(givenEtag)) {
                if (log.isDebugEnabled()) {
                    log.debug("Sending 304 for " + this.filePath + " Old ETag=" + givenEtag + ", New ETag=" + etag);
                }
                return true;
            }
            return false;
        }
        if (etag.equals(givenEtag) && modifiedSince >= servletContainerStartTime) {
            if (log.isDebugEnabled()) {
                log.debug("Sending 304 for " + this.filePath);
            }
            return true;
        }
        return false;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }

    public void setIgnoreLastModified(boolean ignoreLastModified) {
        this.ignoreLastModified = ignoreLastModified;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public void setScriptCompressed(boolean scriptCompressed) {
        this.scriptCompressed = scriptCompressed;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setScriptTagProtection(String scriptTagProtection) {
        this.scriptTagProtection = scriptTagProtection;
    }

    public void setOverridePath(String overridePath) {
        this.overridePath = overridePath;
    }

    public void setMaxWaitAfterWrite(int maxWaitAfterWrite) {
        this.maxWaitAfterWrite = maxWaitAfterWrite;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        long now = System.currentTimeMillis();
        servletContainerStartTime = now - now % 1000L;
        etag = "\"" + servletContainerStartTime + '\"';
        log = Logger.getLogger(class$org$directwebremoting$servlet$FileHandler == null ? (class$org$directwebremoting$servlet$FileHandler = FileHandler.class$("org.directwebremoting.servlet.FileHandler")) : class$org$directwebremoting$servlet$FileHandler);
    }
}

