/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.dwrp.PartialResponse;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.util.Messages;

public class PollBatch {
    private String batchId;
    private String scriptId;
    private int partialResponse;
    private boolean get;
    private String debug;
    private RealScriptSession scriptSession;
    public static final String ATTRIBUTE_PARAMETERS = "org.directwebremoting.dwrp.parameters";
    public static final String ATTRIBUTE_CALL_ID = "org.directwebremoting.dwrp.callId";
    public static final String ATTRIBUTE_SESSION_ID = "org.directwebremoting.dwrp.sessionId";
    public static final String ATTRIBUTE_PAGE = "org.directwebremoting.dwrp.page";
    public static final String ATTRIBUTE_PARTIAL_RESPONSE = "org.directwebremoting.dwrp.partialResponse";
    public static final String ATTRIBUTE_NOTIFY_CONDUIT = "org.directwebremoting.dwrp.notifyConduit";

    public PollBatch(HttpServletRequest request, PageNormalizer pageNormalizer) throws ServerException {
        this.debug = request.getHeader("User-Agent");
        this.get = "GET".equals(request.getMethod());
        Map parameters = null;
        parameters = this.get ? ParseUtil.parseGet(request) : ParseUtil.parsePost(request);
        this.batchId = this.extractParameter(parameters, "batchId");
        this.scriptId = this.extractParameter(parameters, "scriptSessionId");
        String page = this.extractParameter(parameters, "page");
        String prString = this.extractParameter(parameters, "partialResponse");
        this.partialResponse = PartialResponse.fromOrdinal(prString);
        WebContext webContext = WebContextFactory.get();
        String normalizedPage = pageNormalizer.normalizePage(page);
        webContext.setCurrentPageInformation(normalizedPage, this.scriptId);
        this.scriptSession = (RealScriptSession)webContext.getScriptSession();
    }

    protected String extractParameter(Map parameters, String paramName) {
        String id = (String)parameters.remove(paramName);
        if (id == null) {
            throw new IllegalArgumentException(Messages.getString("PollHandler.MissingParameter", paramName));
        }
        return id;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public int getPartialResponse() {
        return this.partialResponse;
    }

    public boolean isGet() {
        return this.get;
    }

    public RealScriptSession getScriptSession() {
        return this.scriptSession;
    }

    public String toString() {
        return "PollBatch[partResp=" + this.partialResponse + ",debug=" + this.debug + "]";
    }
}

