/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AccessDeniedException;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.LoginRequiredException;
import org.directwebremoting.util.Messages;

public class DefaultAccessControl
implements AccessControl {
    protected boolean exposeInternals = false;
    protected Map policyMap = new HashMap();
    protected Map roleRestrictMap = new HashMap();
    protected static final String PACKAGE_DWR_DENY = "org.directwebremoting.";
    static /* synthetic */ Class class$java$lang$Object;

    public void assertExecutionIsPossible(Creator creator, String className, Method method) throws SecurityException {
        this.assertIsRestrictedByRole(className, method);
        this.assertIsDisplayable(creator, className, method);
    }

    public void assertIsDisplayable(Creator creator, String className, Method method) throws SecurityException {
        this.assertIsMethodPublic(method);
        this.assertIsExecutable(className, method.getName());
        this.assertIsNotOnBaseObject(method);
        if (!this.exposeInternals) {
            this.assertIsClassDwrInternal(creator);
            this.assertAreParametersDwrInternal(method);
        }
    }

    public void addRoleRestriction(String scriptName, String methodName, String role) {
        String key = scriptName + '.' + methodName;
        HashSet<String> roles = (HashSet<String>)this.roleRestrictMap.get(key);
        if (roles == null) {
            roles = new HashSet<String>();
            this.roleRestrictMap.put(key, roles);
        }
        roles.add(role);
    }

    public void addIncludeRule(String scriptName, String methodName) {
        Policy policy = this.getPolicy(scriptName);
        if (policy.defaultAllow) {
            if (policy.rules.size() > 0) {
                throw new IllegalArgumentException(Messages.getString("DefaultAccessControl.MixedIncludesAndExcludes", scriptName));
            }
            policy.defaultAllow = false;
        }
        policy.rules.add(methodName);
    }

    public void addExcludeRule(String scriptName, String methodName) {
        Policy policy = this.getPolicy(scriptName);
        if (!policy.defaultAllow) {
            if (policy.rules.size() > 0) {
                throw new IllegalArgumentException(Messages.getString("DefaultAccessControl.MixedIncludesAndExcludes", scriptName));
            }
            policy.defaultAllow = true;
        }
        policy.rules.add(methodName);
    }

    protected void assertIsRestrictedByRole(String scriptName, Method method) {
        String methodName = method.getName();
        Set roles = this.getRoleRestrictions(scriptName, methodName);
        if (roles != null && !roles.isEmpty()) {
            HttpServletRequest req = WebContextFactory.get().getHttpServletRequest();
            this.assertAuthenticationIsValid(req);
            this.assertAllowedByRoles(req, roles);
        }
    }

    protected Set getRoleRestrictions(String scriptName, String methodName) {
        String key = scriptName + '.' + methodName;
        return (Set)this.roleRestrictMap.get(key);
    }

    protected void assertAuthenticationIsValid(HttpServletRequest req) throws SecurityException {
        req.getSession();
        if (!req.isRequestedSessionIdValid()) {
            throw new LoginRequiredException(Messages.getString("DefaultAccessControl.DeniedByInvalidSession"));
        }
        if (req.getRemoteUser() == null) {
            throw new LoginRequiredException(Messages.getString("DefaultAccessControl.DeniedByAuthenticationRequired"));
        }
    }

    protected void assertAllowedByRoles(HttpServletRequest req, Set roles) throws SecurityException {
        Iterator it = roles.iterator();
        while (it.hasNext()) {
            String role = (String)it.next();
            if (!"*".equals(role) && !req.isUserInRole(role)) continue;
            return;
        }
        throw new AccessDeniedException(Messages.getString("DefaultAccessControl.DeniedByJ2EERoles"));
    }

    protected void assertIsMethodPublic(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new SecurityException(Messages.getString("DefaultAccessControl.DeniedNonPublic"));
        }
    }

    protected void assertIsNotOnBaseObject(Method method) {
        if (method.getDeclaringClass() == (class$java$lang$Object == null ? (class$java$lang$Object = DefaultAccessControl.class$("java.lang.Object")) : class$java$lang$Object)) {
            throw new SecurityException(Messages.getString("DefaultAccessControl.DeniedObjectMethod"));
        }
    }

    protected void assertIsExecutable(String scriptName, String methodName) throws SecurityException {
        Policy policy = (Policy)this.policyMap.get(scriptName);
        if (policy == null) {
            return;
        }
        String match = null;
        Iterator it = policy.rules.iterator();
        while (it.hasNext() && match == null) {
            String test = (String)it.next();
            if (!methodName.equals(test)) continue;
            match = test;
        }
        if (policy.defaultAllow && match != null) {
            throw new SecurityException(Messages.getString("DefaultAccessControl.DeniedByAccessRules"));
        }
        if (!policy.defaultAllow && match == null) {
            throw new SecurityException(Messages.getString("DefaultAccessControl.DeniedByAccessRules"));
        }
    }

    protected void assertAreParametersDwrInternal(Method method) {
        for (int j = 0; j < method.getParameterTypes().length; ++j) {
            Class<?> paramType = method.getParameterTypes()[j];
            if (!paramType.getName().startsWith(PACKAGE_DWR_DENY)) continue;
            throw new SecurityException(Messages.getString("DefaultAccessControl.DeniedParamDWR"));
        }
    }

    protected void assertIsClassDwrInternal(Creator creator) {
        if (creator.getType().getName().startsWith(PACKAGE_DWR_DENY)) {
            throw new SecurityException(Messages.getString("DefaultAccessControl.DeniedCoreDWR"));
        }
    }

    protected Policy getPolicy(String type) {
        Policy policy = (Policy)this.policyMap.get(type);
        if (policy == null) {
            policy = new Policy();
            this.policyMap.put(type, policy);
        }
        return policy;
    }

    public void setExposeInternals(boolean exposeInternals) {
        this.exposeInternals = exposeInternals;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Policy {
        boolean defaultAllow = true;
        List rules = new ArrayList();

        Policy() {
        }
    }
}

