/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.impl.ContainerMap;
import org.directwebremoting.impl.ContainerUtil;
import org.directwebremoting.impl.StartupUtil;
import org.directwebremoting.servlet.UrlProcessor;
import org.directwebremoting.spring.SpringContainer;
import org.directwebremoting.util.FakeServletConfig;
import org.directwebremoting.util.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class DwrController
extends AbstractController
implements BeanNameAware,
InitializingBean,
BeanFactoryAware {
    private String name;
    private boolean debug = false;
    protected WebContextFactory.WebContextBuilder webContextBuilder;
    private SpringContainer container;
    private ServletConfig servletConfig;
    private boolean includeDefaultConfig = true;
    private List configurators;
    private Map configParams = new HashMap();
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$spring$DwrController == null ? (class$org$directwebremoting$spring$DwrController = DwrController.class$("org.directwebremoting.spring.DwrController")) : class$org$directwebremoting$spring$DwrController);
    static /* synthetic */ Class class$org$directwebremoting$servlet$UrlProcessor;
    static /* synthetic */ Class class$org$directwebremoting$spring$DwrController;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.container = new SpringContainer();
        this.container.setBeanFactory(beanFactory);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setConfigurators(List configurators) {
        this.configurators = configurators;
    }

    public void setIncludeDefaultConfig(boolean includeDefaultConfig) {
        this.includeDefaultConfig = includeDefaultConfig;
    }

    public void afterPropertiesSet() throws Exception {
        ServletContext servletContext = this.getServletContext();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("afterPropertiesSet() called with servletContext '" + servletContext + "'"));
        }
        Assert.notNull((Object)servletContext, (String)"The servlet context has not been set on the controller");
        Assert.notNull((Object)this.configurators, (String)"The required 'configurators' property should be set");
        this.configParams.putAll(new ContainerMap(this.container, true));
        this.servletConfig = new FakeServletConfig(this.name, servletContext, this.configParams);
        try {
            ContainerUtil.setupDefaults(this.container, this.servletConfig);
            ContainerUtil.setupFromServletConfig(this.container, this.servletConfig);
            this.container.addParameter("debug", "" + this.debug);
            this.container.setupFinished();
            this.webContextBuilder = StartupUtil.initWebContext(this.servletConfig, servletContext, this.container);
            StartupUtil.initServerContext(this.servletConfig, servletContext, this.container);
            ContainerUtil.prepareForWebContextFilter(servletContext, this.servletConfig, this.container, this.webContextBuilder, null);
            if (this.includeDefaultConfig) {
                ContainerUtil.configureFromSystemDwrXml(this.container);
            }
            ContainerUtil.configure(this.container, this.configurators);
            ContainerUtil.publishContainer(this.container, this.servletConfig);
        }
        catch (InstantiationException ex) {
            throw new BeanCreationException("Failed to instansiate", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanCreationException("Access error", (Throwable)ex);
        }
        catch (Exception ex) {
            log.fatal("init failed", ex);
            throw ex;
        }
        finally {
            this.webContextBuilder.unset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.webContextBuilder.set(request, response, this.servletConfig, this.getServletContext(), this.container);
            UrlProcessor processor = (UrlProcessor)this.container.getBean((class$org$directwebremoting$servlet$UrlProcessor == null ? (class$org$directwebremoting$servlet$UrlProcessor = DwrController.class$("org.directwebremoting.servlet.UrlProcessor")) : class$org$directwebremoting$servlet$UrlProcessor).getName());
            processor.handle(request, response);
        }
        finally {
            this.webContextBuilder.unset();
        }
        return null;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setConfigParams(Map configParams) {
        Assert.notNull((Object)configParams, (String)"configParams cannot be null");
        this.configParams = configParams;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

