/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.annotations;

import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.directwebremoting.AjaxFilter;
import org.directwebremoting.Container;
import org.directwebremoting.annotations.Auth;
import org.directwebremoting.annotations.DataTransferObject;
import org.directwebremoting.annotations.Filter;
import org.directwebremoting.annotations.Filters;
import org.directwebremoting.annotations.GlobalFilter;
import org.directwebremoting.annotations.Param;
import org.directwebremoting.annotations.RemoteMethod;
import org.directwebremoting.annotations.RemoteProperty;
import org.directwebremoting.annotations.RemoteProxy;
import org.directwebremoting.convert.BeanConverter;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.util.ClasspathScanner;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Loggers;

public class AnnotationsConfigurator
implements Configurator {
    private static final String METHOD_PREFIX_IS = "is";
    private static final String METHOD_PREFIX_GET = "get";

    @Override
    public void configure(Container container) {
        for (Class<?> clazz : this.getClasses(container)) {
            try {
                this.processClass(clazz, container);
            }
            catch (Exception ex) {
                Loggers.STARTUP.error((Object)("Failed to process class: " + clazz.getName()), (Throwable)ex);
            }
        }
    }

    protected Set<Class<?>> getClasses(Container container) {
        HashSet classes;
        block11: {
            classes = new HashSet();
            Object data = container.getBean("classes");
            if (data == null) break block11;
            if (data instanceof String) {
                String classesStr = (String)data;
                for (String element : classesStr.split(",")) {
                    if ((element = element.trim()).length() == 0) continue;
                    if (element.endsWith(".*") || element.endsWith(".**")) {
                        try {
                            boolean recursive = element.endsWith(".**");
                            String packageName = element.substring(0, element.length() - 2 - (recursive ? 1 : 0));
                            Set<String> classesInPackage = new ClasspathScanner(packageName, recursive).getClasses();
                            for (String className : classesInPackage) {
                                Class<?> clazz = LocalUtil.classForName(className);
                                classes.add(clazz);
                            }
                            continue;
                        }
                        catch (Exception ex) {
                            Loggers.STARTUP.error((Object)("Failed to process package: " + element), (Throwable)ex);
                            continue;
                        }
                    }
                    try {
                        Class<?> clazz = LocalUtil.classForName(element);
                        classes.add(clazz);
                    }
                    catch (Exception ex) {
                        Loggers.STARTUP.error((Object)("Failed to process class: " + element), (Throwable)ex);
                    }
                }
            } else {
                try {
                    classes.add(data.getClass());
                }
                catch (Exception ex) {
                    Loggers.STARTUP.error((Object)("Failed to process class: " + data.getClass().getName()), (Throwable)ex);
                }
            }
        }
        return classes;
    }

    protected void processClass(Class<?> clazz, Container container) throws InstantiationException, IllegalAccessException {
        GlobalFilter globalFilterAnn;
        DataTransferObject convertAnn;
        RemoteProxy createAnn = clazz.getAnnotation(RemoteProxy.class);
        if (createAnn != null) {
            this.processCreate(clazz, createAnn, container);
        }
        if ((convertAnn = clazz.getAnnotation(DataTransferObject.class)) != null) {
            this.processConvert(clazz, convertAnn, container);
        }
        if ((globalFilterAnn = clazz.getAnnotation(GlobalFilter.class)) != null) {
            this.processGlobalFilter(clazz, globalFilterAnn, container);
        }
    }

    protected void processCreate(Class<?> clazz, RemoteProxy createAnn, Container container) {
        String scriptName;
        Class<? extends Creator> creatorClass = createAnn.creator();
        String creatorClassName = creatorClass.getName();
        CreatorManager creatorManager = container.getBean(CreatorManager.class);
        String creatorName = creatorClassName.replace(".", "_");
        creatorManager.addCreatorType(creatorName, creatorClassName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(this.getParamsMap(createAnn.creatorParams()));
        if (createAnn.name() != null && !createAnn.name().equals("")) {
            params.put("javascript", createAnn.name());
        }
        params.put("scope", createAnn.scope().getValue());
        if (params.get("class") == null) {
            params.put("class", clazz.getName());
        }
        if ((scriptName = (String)params.get("javascript")) == null || scriptName.equals("")) {
            scriptName = clazz.getSimpleName();
            params.put("javascript", scriptName);
        }
        try {
            Loggers.STARTUP.debug((Object)("Adding class " + clazz.getName() + " as " + scriptName));
            creatorManager.addCreator(creatorName, params);
        }
        catch (Exception ex) {
            Loggers.STARTUP.error((Object)("Failed to add class as Creator: " + clazz.getName()), (Throwable)ex);
        }
        AccessControl accessControl = container.getBean(AccessControl.class);
        for (Method method : clazz.getMethods()) {
            if (method.getAnnotation(RemoteMethod.class) == null) continue;
            accessControl.addIncludeRule(scriptName, method.getName());
            Auth authAnn = method.getAnnotation(Auth.class);
            if (authAnn == null) continue;
            for (String role : authAnn.role()) {
                accessControl.addRoleRestriction(scriptName, method.getName(), role);
            }
        }
        Filters filtersAnn = clazz.getAnnotation(Filters.class);
        if (filtersAnn != null) {
            Filter[] fs;
            for (Filter filter : fs = filtersAnn.value()) {
                this.processFilter(filter, scriptName, container);
            }
        } else {
            Filter filterAnn = clazz.getAnnotation(Filter.class);
            if (filterAnn != null) {
                this.processFilter(filterAnn, scriptName, container);
            }
        }
    }

    protected void processFilter(Filter filterAnn, String name, Container container) {
        Map<String, String> filterParams = this.getParamsMap(filterAnn.params());
        AjaxFilter filter = LocalUtil.classNewInstance(name, filterAnn.type().getName(), AjaxFilter.class);
        if (filter != null) {
            LocalUtil.setParams(filter, filterParams, null);
            AjaxFilterManager filterManager = container.getBean(AjaxFilterManager.class);
            filterManager.addAjaxFilter(filter, name);
        }
    }

    protected void processConvert(Class<?> clazz, DataTransferObject convertAnn, Container container) throws InstantiationException, IllegalAccessException {
        Class<? extends Converter> converter = convertAnn.converter();
        String converterClass = converter.getName();
        Map<String, String> params = this.getParamsMap(convertAnn.params());
        ConverterManager converterManager = container.getBean(ConverterManager.class);
        String converterName = converterClass.replace(".", "_");
        converterManager.addConverterType(converterName, converterClass);
        if (BeanConverter.class.isAssignableFrom(converter)) {
            StringBuilder properties = new StringBuilder();
            for (Class<?> superClazz = clazz; superClazz != null && superClazz != Object.class; superClazz = superClazz.getSuperclass()) {
                for (Field field : superClazz.getDeclaredFields()) {
                    if (field.getAnnotation(RemoteProperty.class) == null) continue;
                    properties.append(',').append(field.getName());
                }
                for (AccessibleObject accessibleObject : superClazz.getMethods()) {
                    String name;
                    if (((Method)accessibleObject).getAnnotation(RemoteProperty.class) == null || !(name = ((Method)accessibleObject).getName()).startsWith(METHOD_PREFIX_GET) && !name.startsWith(METHOD_PREFIX_IS)) continue;
                    name = name.startsWith(METHOD_PREFIX_GET) ? name.substring(3) : name.substring(2);
                    name = Introspector.decapitalize(name);
                    properties.append(',').append(name);
                }
            }
            if (properties.length() > 0) {
                properties.deleteCharAt(0);
                params.put("include", properties.toString());
            }
        }
        converterManager.addConverter(clazz.getName(), converterName, params);
    }

    protected void processGlobalFilter(Class<?> clazz, GlobalFilter globalFilterAnn, Container container) throws InstantiationException, IllegalAccessException {
        if (!AjaxFilter.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not an AjaxFilter implementation");
        }
        Map<String, String> filterParams = this.getParamsMap(globalFilterAnn.params());
        AjaxFilter filter = (AjaxFilter)clazz.newInstance();
        if (filter != null) {
            LocalUtil.setParams(filter, filterParams, null);
            AjaxFilterManager filterManager = container.getBean(AjaxFilterManager.class);
            filterManager.addAjaxFilter(filter);
        }
    }

    protected Map<String, String> getParamsMap(Param[] params) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (params != null) {
            for (Param param : params) {
                result.put(param.name(), param.value());
            }
        }
        return result;
    }
}

