/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.BaseDwrpHandler;
import org.directwebremoting.dwrp.Batch;
import org.directwebremoting.dwrp.CallBatch;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MethodDeclaration;
import org.directwebremoting.extend.ModuleManager;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.ParameterProperty;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.RealWebContext;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.extend.SimpleInputStreamFactory;
import org.directwebremoting.impl.AccessLogLevel;
import org.directwebremoting.impl.ExportUtil;
import org.directwebremoting.io.FileTransfer;
import org.directwebremoting.util.DebuggingPrintWriter;
import org.directwebremoting.util.LocalUtil;

public abstract class BaseCallHandler
extends BaseDwrpHandler {
    protected boolean debug = false;
    protected Remoter remoter = null;
    protected boolean debugScriptOutput = false;
    protected boolean jsonOutput = false;
    protected String accessLogLevel = null;
    protected PageNormalizer pageNormalizer = null;
    protected ConverterManager converterManager = null;
    protected ModuleManager moduleManager = null;
    protected static final String ATTRIBUTE_BATCH = "org.directwebremoting.dwrp.batch";
    private static final Log log = LogFactory.getLog(BaseCallHandler.class);

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean scriptPrefixSent = false;
        try {
            CallBatch batch = new CallBatch(request);
            this.checkGetAllowed(batch);
            boolean checkCsrf = false;
            for (int i = 0; i < batch.getCalls().getCallCount(); ++i) {
                Call call = batch.getCalls().getCall(i);
                if (ExportUtil.isUnprotectedSystemMethod(call.getScriptName(), call.getMethodName())) continue;
                checkCsrf = true;
                break;
            }
            if (checkCsrf) {
                this.checkNotCsrfAttack(request, batch);
            }
            request.setAttribute(ATTRIBUTE_BATCH, (Object)batch);
            String normalizedPage = this.pageNormalizer.normalizePage(batch.getPage());
            RealWebContext webContext = (RealWebContext)WebContextFactory.get();
            webContext.checkPageInformation(normalizedPage, batch.getScriptSessionId(), batch.getWindowName());
            this.storeParsedRequest(request, webContext, batch);
            Calls calls = this.marshallInbound(batch);
            Replies replies = this.remoter.execute(calls);
            scriptPrefixSent = true;
            this.marshallOutbound(batch, replies, response);
        }
        catch (Exception ex) {
            if (this.debug) {
                if (LocalUtil.getRootCause(ex) instanceof IOException) {
                    log.debug((Object)"I/O error while processing batch", (Throwable)ex);
                } else {
                    log.warn((Object)"Exception while processing batch", (Throwable)ex);
                }
            }
            this.marshallException(request, response, ex, !scriptPrefixSent);
        }
    }

    public Calls marshallInbound(CallBatch batch) {
        Calls calls = batch.getCalls();
        for (int callNum = 0; callNum < calls.getCallCount(); ++callNum) {
            Call call = calls.getCall(callNum);
            try {
                InboundContext inctx = batch.getInboundContexts().get(callNum);
                call.findMethod(this.moduleManager, this.converterManager, inctx, callNum);
                MethodDeclaration method = call.getMethodDeclaration();
                if (method == null) {
                    log.warn((Object)("No methods to match " + call.getScriptName() + '.' + call.getMethodName()));
                    throw new IllegalArgumentException("Missing method or missing parameter converters");
                }
                inctx.dereference();
                int destParamCount = method.getParameterTypes().length;
                Object[] arguments = new Object[destParamCount];
                int inboundArgIndex = 0;
                for (int outboundArgIndex = 0; outboundArgIndex < destParamCount; ++outboundArgIndex) {
                    InboundVariable param = method.isVarArgs() && outboundArgIndex + 1 == destParamCount ? inctx.createArrayWrapper(callNum, destParamCount) : inctx.getParameter(callNum, inboundArgIndex);
                    ParameterProperty property = new ParameterProperty(method, outboundArgIndex);
                    Class<?> paramType = method.getParameterTypes()[outboundArgIndex];
                    try {
                        arguments[outboundArgIndex] = this.converterManager.convertInbound(paramType, param, property);
                    }
                    catch (Exception ex) {
                        log.debug((Object)("Problem converting param=" + param + ", property=" + property + ", into paramType=" + paramType.getName() + ": " + ex));
                        throw ex;
                    }
                    if (LocalUtil.isServletClass(paramType)) continue;
                    ++inboundArgIndex;
                }
                call.setParameters(arguments);
                continue;
            }
            catch (Exception ex) {
                log.debug((Object)"Marshalling exception", (Throwable)ex);
                call.setMarshallFailure(ex);
            }
        }
        return calls;
    }

    private void storeParsedRequest(HttpServletRequest request, RealWebContext webContext, CallBatch batch) throws IOException {
        Map<String, FormField> paramMap = batch.getExtraParameters();
        if (!paramMap.isEmpty()) {
            for (Map.Entry<String, FormField> entry : paramMap.entrySet()) {
                Object value;
                String key = entry.getKey();
                FormField formField = entry.getValue();
                if (formField == null) {
                    log.warn((Object)"Found a parameter with a null value. This is likely to be due to a URL with an & before the query parameters. Please URL encode such pages.");
                    throw new IllegalArgumentException("Empty input parameter. See logs for suggestions");
                }
                if (formField.isFile()) {
                    SimpleInputStreamFactory inFactory = new SimpleInputStreamFactory(formField.getInputStream());
                    value = new FileTransfer(formField.getName(), formField.getMimeType(), formField.getFileSize(), inFactory);
                } else {
                    value = formField.getString();
                }
                if (key.startsWith("a-")) {
                    request.setAttribute(key.substring("a-".length()), value);
                    log.debug((Object)("Moved param to request: " + key + "=" + value));
                    continue;
                }
                log.debug((Object)("Ignoring parameter: " + key + "=" + value));
            }
        }
    }

    public void marshallOutbound(Batch batch, Replies replies, HttpServletResponse response) throws IOException {
        int i;
        RealScriptSession scriptSession;
        try {
            scriptSession = (RealScriptSession)WebContextFactory.get().getScriptSession();
        }
        catch (SecurityException ex) {
            return;
        }
        response.setContentType(this.getOutboundMimeType());
        PrintWriter out = this.debugScriptOutput || AccessLogLevel.getValue(this.accessLogLevel, this.debug).hierarchy() == 0 ? new DebuggingPrintWriter("", response.getWriter()) : response.getWriter();
        if (out instanceof DebuggingPrintWriter) {
            PrintWriter dpw = out;
            ((DebuggingPrintWriter)dpw).setPrefix("out(" + replies.hashCode() + "): ");
        }
        this.sendOutboundScriptPrefix(out, batch.getInstanceId(), batch.getBatchId(), batch.getDocumentDomain());
        if (batch.getNextReverseAjaxIndex() != null) {
            out.println("//#DWR-INSERT");
            scriptSession.confirmScripts(batch.getNextReverseAjaxIndex() - 1L);
            RealScriptSession.Scripts scripts = scriptSession.getScripts(batch.getNextReverseAjaxIndex());
            for (i = 0; i < scripts.getScripts().size(); ++i) {
                this.sendScript(out, EnginePrivate.getRemoteHandleReverseAjaxScript(scripts.getScriptIndexOffset() + (long)i, scripts.getScripts().get(i)));
            }
        }
        out.println("//#DWR-REPLY");
        String batchId = replies.getCalls().getBatchId();
        for (i = 0; i < replies.getReplyCount(); ++i) {
            ScriptBuffer script;
            Reply reply = replies.getReply(i);
            String callId = reply.getCallId();
            try {
                ScriptBuffer script2;
                if (reply.getThrowable() != null) {
                    Throwable ex = reply.getThrowable();
                    script2 = EnginePrivate.getRemoteHandleExceptionScript(batchId, callId, ex);
                } else {
                    Object data = reply.getReply();
                    script2 = EnginePrivate.getRemoteHandleCallbackScript(batchId, callId, data);
                }
                this.sendScript(out, ScriptBufferUtil.createOutput(script2, this.converterManager, this.jsonOutput));
                continue;
            }
            catch (IOException ex) {
                log.error((Object)("--Output Error: batchId[" + batchId + "] message[" + ex.toString() + ']'), (Throwable)ex);
                continue;
            }
            catch (ConversionException ex) {
                script = EnginePrivate.getRemoteHandleExceptionScript(batchId, callId, ex);
                this.addScriptHandleExceptions(out, script);
                log.warn((Object)("--ConversionException: batchId=" + batchId + " class=" + ex.getConversionType().getName()), (Throwable)ex);
                continue;
            }
            catch (Exception ex) {
                script = EnginePrivate.getRemoteHandleExceptionScript(batchId, callId, ex);
                this.addScriptHandleExceptions(out, script);
                log.error((Object)("--ConversionException: batchId=" + batchId + " message=" + ex.toString()));
            }
        }
        this.sendOutboundScriptSuffix(out, replies.getCalls().getInstanceId(), replies.getCalls().getBatchId());
    }

    public void marshallException(HttpServletRequest request, HttpServletResponse response, Exception ex, boolean sendPrefix) throws IOException {
        response.setContentType(this.getOutboundMimeType());
        PrintWriter out = response.getWriter();
        Batch batch = (Batch)request.getAttribute(ATTRIBUTE_BATCH);
        String batchId = null;
        String instanceId = "0";
        String documentDomain = null;
        if (batch != null) {
            batchId = batch.getBatchId();
            instanceId = batch.getInstanceId();
            documentDomain = batch.getDocumentDomain();
        }
        if (sendPrefix) {
            this.sendOutboundScriptPrefix(out, instanceId, batchId, documentDomain);
        }
        String script = EnginePrivate.getRemoteHandleBatchExceptionScript(batchId, ex);
        out.println(script);
        this.sendOutboundScriptSuffix(out, instanceId, batchId);
    }

    public void addScriptHandleExceptions(PrintWriter out, ScriptBuffer script) throws IOException {
        try {
            this.sendScript(out, ScriptBufferUtil.createOutput(script, this.converterManager, this.jsonOutput));
        }
        catch (ConversionException ex) {
            log.warn((Object)"Error marshalling exception. Is the exception converter configured?", (Throwable)ex);
        }
    }

    protected abstract void sendScript(PrintWriter var1, String var2) throws IOException;

    protected abstract String getOutboundMimeType();

    protected abstract void sendOutboundScriptPrefix(PrintWriter var1, String var2, String var3, String var4) throws IOException;

    protected abstract void sendOutboundScriptSuffix(PrintWriter var1, String var2, String var3) throws IOException;

    public boolean isConvertable(Class<?> paramType) {
        return this.converterManager.isConvertable(paramType);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setRemoter(Remoter remoter) {
        this.remoter = remoter;
    }

    public void setDebugScriptOutput(boolean debugScriptOutput) {
        this.debugScriptOutput = debugScriptOutput;
    }

    public boolean isJsonOutput() {
        return this.jsonOutput;
    }

    public void setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
    }

    public void setAccessLogLevel(String accessLogLevel) {
        this.accessLogLevel = accessLogLevel;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }
}

