/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.dwrp.Batch;
import org.directwebremoting.extend.Handler;

public abstract class BaseDwrpHandler
implements Handler {
    private boolean crossDomainSessionSecurity = true;
    private boolean allowGetForSafariButMakeForgeryEasier = false;
    private static final Log log = LogFactory.getLog(BaseDwrpHandler.class);

    protected void checkGetAllowed(Batch batch) {
        if (!this.allowGetForSafariButMakeForgeryEasier && batch.isGet()) {
            log.error((Object)"GET is disallowed because it makes request forgery easier. See allowGetForSafariButMakeForgeryEasier setting for more details.");
            throw new SecurityException("GET Disallowed");
        }
    }

    protected void checkNotCsrfAttack(HttpServletRequest request, Batch batch) {
        if (!this.crossDomainSessionSecurity) {
            return;
        }
        if (request.getCookies() != null) {
            int dwrCookieCount = 0;
            int dwrCookieMatchCount = 0;
            for (Cookie cookie : request.getCookies()) {
                if (!cookie.getName().equals("DWRSESSIONID")) continue;
                ++dwrCookieCount;
                if (!cookie.getValue().equals(batch.getDwrSessionId())) continue;
                ++dwrCookieMatchCount;
            }
            if (dwrCookieCount > 0 && dwrCookieMatchCount == 0) {
                log.error((Object)"A request has been denied as a potential CSRF attack. This security check is performed as DWR's crossDomainSessionSecurity setting is active. Read more in the DWR documentation.");
                throw new SecurityException("CSRF Security Error (see server log for details).");
            }
            if (dwrCookieCount > 1 && dwrCookieMatchCount != dwrCookieCount) {
                log.warn((Object)"Multiple DWRSESSIONID cookies with different values in request.");
            }
        }
    }

    public void setCrossDomainSessionSecurity(boolean crossDomainSessionSecurity) {
        this.crossDomainSessionSecurity = crossDomainSessionSecurity;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }
}

