/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.extend.ScriptConduit;

public abstract class BaseScriptConduit
implements ScriptConduit {
    protected boolean debugScriptOutput = false;
    protected boolean jsonOutput = false;
    protected String accessLogLevel = null;
    protected ConverterManager converterManager = null;
    protected final String instanceId;
    protected final String batchId;

    public BaseScriptConduit(String instanceId, String batchId, ConverterManager converterManager, boolean jsonOutput) throws IOException {
        this.instanceId = instanceId;
        this.batchId = batchId;
        this.converterManager = converterManager;
        this.jsonOutput = jsonOutput;
    }

    protected void sendPollReply(PrintWriter out, int timetoNextPoll) throws IOException {
        this.sendBeginChunk(out);
        ScriptBuffer script = EnginePrivate.getRemoteHandleCallbackScript(this.batchId, "0", timetoNextPoll);
        this.sendScript(out, ScriptBufferUtil.createOutput(script, this.converterManager, this.jsonOutput));
        this.sendEndChunk(out);
    }

    public void setAccessLogLevel(String accessLogLevel) {
        this.accessLogLevel = accessLogLevel;
    }

    public void setDebugScriptOutput(boolean debugScriptOutput) {
        this.debugScriptOutput = debugScriptOutput;
    }
}

