/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;

public class HtmlScriptConduit
extends BaseScriptConduit {
    private final String documentDomain;

    public HtmlScriptConduit(String instanceId, String batchId, String documentDomain, ConverterManager converterManager, boolean jsonOutput) throws IOException {
        super(instanceId, batchId, converterManager, jsonOutput);
        this.documentDomain = documentDomain;
    }

    @Override
    public String getOutboundMimeType() {
        return "text/html";
    }

    @Override
    public void sendBeginStream(PrintWriter out) {
        out.println("<html><body>");
        out.println("<script type=\"text/javascript\">");
        out.println(EnginePrivate.remoteBeginWrapper(this.instanceId, true, this.documentDomain));
        out.println(EnginePrivate.remoteBeginIFrameResponse(this.batchId, true));
        out.println(EnginePrivate.remoteEndWrapper(this.instanceId, true));
        out.println("</script>");
    }

    @Override
    public void sendBeginChunk(PrintWriter out) {
        out.println("<script type=\"text/javascript\">");
        out.println(EnginePrivate.remoteBeginWrapper(this.instanceId, true, null));
    }

    @Override
    public void sendScript(PrintWriter out, String script) throws IOException {
        out.println(EnginePrivate.remoteExecute(script));
    }

    @Override
    public void sendEndChunk(PrintWriter out) {
        out.println(EnginePrivate.remoteEndWrapper(this.instanceId, true));
        out.println("</script>");
    }

    @Override
    public void sendEndStream(PrintWriter out, int timetoNextPoll) throws IOException {
        this.sendPollReply(out, timetoNextPoll);
        out.println("<script type=\"text/javascript\">");
        out.println(EnginePrivate.remoteBeginWrapper(this.instanceId, true, null));
        out.println(EnginePrivate.remoteEndIFrameResponse(this.batchId, true));
        out.println(EnginePrivate.remoteEndWrapper(this.instanceId, true));
        out.println("</script>");
        out.println("</body></html>");
    }
}

