/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;

public class PlainScriptConduit
extends BaseScriptConduit {
    private static final Log log = LogFactory.getLog(PlainScriptConduit.class);

    public PlainScriptConduit(String instanceId, String batchId, ConverterManager converterManager, boolean jsonOutput) throws IOException {
        super(instanceId, batchId, converterManager, jsonOutput);
    }

    @Override
    public String getOutboundMimeType() {
        return "text/javascript; charset=utf-8";
    }

    @Override
    public void sendBeginStream(PrintWriter out) {
    }

    @Override
    public void sendBeginChunk(PrintWriter out) {
        out.println("//#DWR-START#");
        out.println(EnginePrivate.remoteBeginWrapper(this.instanceId, false, null));
    }

    @Override
    public void sendScript(PrintWriter out, String script) throws IOException, ConversionException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Execution time: " + new Date().toString() + " - Writing to response: " + script));
        }
        out.println(script);
    }

    @Override
    public void sendEndChunk(PrintWriter out) {
        out.println(EnginePrivate.remoteEndWrapper(this.instanceId, false));
        out.println("//#DWR-END#");
    }

    @Override
    public void sendEndStream(PrintWriter out, int timetoNextPoll) throws IOException {
        this.sendPollReply(out, timetoNextPoll);
    }
}

