/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.util.LocalUtil;

public abstract class BaseSleeper
implements Sleeper {
    private final HttpServletResponse response;
    private final RealScriptSession scriptSession;
    private final ScriptConduit conduit;
    private final PrintWriter out;
    private Runnable onClose;
    private int disconnectedTime;
    private final Object lock = new Object();
    private boolean closePending = false;
    private boolean opened = false;
    private boolean closed = false;
    private long nextScriptIndex = 0L;
    private static final Log log = LogFactory.getLog(BaseSleeper.class);

    public BaseSleeper(HttpServletResponse response, RealScriptSession scriptSession, ScriptConduit conduit) throws IOException {
        this.response = response;
        this.scriptSession = scriptSession;
        this.conduit = conduit;
        this.out = response.getWriter();
    }

    @Override
    public final void enterSleep(Runnable onClose, int disconnectedTime) throws IOException {
        this.onClose = onClose;
        this.disconnectedTime = disconnectedTime;
        this.enterSleep();
    }

    protected abstract void enterSleep();

    @Override
    public final void wakeUpForData() {
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int wakeUpToClose() {
        Object object = this.lock;
        synchronized (object) {
            this.closePending = true;
        }
        this.wakeUp();
        return this.disconnectedTime;
    }

    protected abstract void wakeUp();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doWork() {
        try {
            if (this.closed) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.closePending) {
                    this.closePending = false;
                    this.closed = true;
                }
            }
            if (!this.opened) {
                this.sendBeginStream();
                this.opened = true;
            }
            if (this.closed) {
                this.sendEndStream();
                this.doClose();
                return;
            }
            this.sendNewScripts();
        }
        catch (Exception ex) {
            if (LocalUtil.getRootCause(ex) instanceof IOException) {
                log.debug((Object)"Poll I/O error", (Throwable)ex);
            } else {
                log.error((Object)"Error during poll.", (Throwable)ex);
            }
            this.closed = true;
            try {
                this.sendEndStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.doClose();
        }
    }

    private void sendBeginStream() {
        this.response.setContentType(this.conduit.getOutboundMimeType());
        this.conduit.sendBeginStream(this.out);
    }

    private void sendEndStream() throws IOException {
        this.conduit.sendEndStream(this.out, this.disconnectedTime);
    }

    private void sendNewScripts() throws IOException {
        RealScriptSession.Scripts scripts = this.scriptSession.getScripts(this.nextScriptIndex);
        if (scripts.getScripts().size() > 0) {
            this.conduit.sendBeginChunk(this.out);
            for (int i = 0; i < scripts.getScripts().size(); ++i) {
                this.conduit.sendScript(this.out, EnginePrivate.getRemoteHandleReverseAjaxScript(scripts.getScriptIndexOffset() + (long)i, scripts.getScripts().get(i)));
            }
            this.conduit.sendEndChunk(this.out);
            this.out.flush();
            if (this.out.checkError()) {
                throw new IOException("Stream write error");
            }
            this.response.flushBuffer();
            this.nextScriptIndex = scripts.getScriptIndexOffset() + (long)scripts.getScripts().size();
            this.scriptSession.updateLastAccessedTime();
        }
    }

    private void doClose() {
        this.close();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    protected abstract void close();
}

