/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.event.ScriptSessionBindingEvent;
import org.directwebremoting.event.ScriptSessionBindingListener;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.DefaultScriptSessionManager;

public class DefaultScriptSession
implements RealScriptSession {
    protected ConverterManager converterManager = null;
    protected boolean jsonOutput = false;
    protected final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private volatile long lastAccessedTime = 0L;
    private volatile long connectionValidationTime = 0L;
    private int connectionValidationTimeout = 10000;
    private volatile boolean invalidated = false;
    protected Sleeper sleeper = null;
    protected Object sleeperLock = new Object();
    protected long scriptsOffset = 0L;
    protected final LinkedList<String> scripts = new LinkedList();
    protected final String id;
    protected final long creationTime;
    protected String page;
    private String windowName;
    protected final ScriptSessionManager manager;

    protected DefaultScriptSession(String id, ScriptSessionManager manager, String page, ConverterManager converterManager, boolean jsonOutput) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        this.manager = manager;
        this.page = page;
        this.converterManager = converterManager;
        this.jsonOutput = jsonOutput;
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
    }

    @Override
    public Object getAttribute(String name) {
        this.invalidateIfNeeded();
        return this.attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.invalidateIfNeeded();
        if (value != null) {
            if (value instanceof ScriptSessionBindingListener) {
                ScriptSessionBindingListener listener = (ScriptSessionBindingListener)value;
                listener.valueBound(new ScriptSessionBindingEvent(this, name));
            }
            this.attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    @Override
    public void removeAttribute(String name) {
        this.invalidateIfNeeded();
        Object value = this.attributes.remove(name);
        if (value != null && value instanceof ScriptSessionBindingListener) {
            ScriptSessionBindingListener listener = (ScriptSessionBindingListener)value;
            listener.valueUnbound(new ScriptSessionBindingEvent(this, name));
        }
    }

    @Override
    public Iterator<String> getAttributeNames() {
        this.invalidateIfNeeded();
        Set<String> keys = Collections.unmodifiableSet(new HashSet<String>(this.attributes.keySet()));
        return keys.iterator();
    }

    @Override
    public void invalidate() {
        this.invalidated = true;
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof ScriptSessionBindingListener)) continue;
            ScriptSessionBindingListener listener = (ScriptSessionBindingListener)value;
            listener.valueUnbound(new ScriptSessionBindingEvent(this, entry.getKey()));
        }
        if (this.manager instanceof DefaultScriptSessionManager) {
            ((DefaultScriptSessionManager)this.manager).invalidate(this);
        }
    }

    @Override
    public boolean isInvalidated() {
        return this.invalidated;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getCreationTime() {
        this.invalidateIfNeeded();
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScript(ScriptBuffer script) {
        this.invalidateIfNeeded();
        if (script == null) {
            throw new NullPointerException("null script");
        }
        Object object = this.scripts;
        synchronized (object) {
            this.scripts.add(ScriptBufferUtil.createOutput(script, this.converterManager, this.jsonOutput));
        }
        object = this.sleeperLock;
        synchronized (object) {
            if (this.sleeper != null) {
                this.sleeper.wakeUpForData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSleeper(Sleeper sleeper) {
        boolean hasNewData;
        this.invalidateIfNeeded();
        Object object = this.scripts;
        synchronized (object) {
            hasNewData = this.scripts.size() > 0;
        }
        object = this.sleeperLock;
        synchronized (object) {
            this.sleeper = sleeper;
            if (hasNewData) {
                this.sleeper.wakeUpForData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSleeper(Sleeper sleeper) {
        this.invalidateIfNeeded();
        Object object = this.sleeperLock;
        synchronized (object) {
            if (this.sleeper == sleeper) {
                this.sleeper = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RealScriptSession.Scripts getScripts(long fromScriptIndex) {
        LinkedList<String> linkedList = this.scripts;
        synchronized (linkedList) {
            if (this.scriptsOffset < 0L) {
                throw new IllegalStateException("Confirmed script index must be set before accessing scripts.");
            }
            long startIndex = fromScriptIndex - this.scriptsOffset;
            if (startIndex < 0L) {
                startIndex = 0L;
            }
            final ArrayList subList = new ArrayList(this.scripts.subList((int)startIndex, this.scripts.size()));
            final long subListOffset = this.scriptsOffset + startIndex;
            return new RealScriptSession.Scripts(){

                @Override
                public long getScriptIndexOffset() {
                    return subListOffset;
                }

                @Override
                public List<String> getScripts() {
                    return subList;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmScripts(long confirmedScriptIndex) {
        long nextScriptIndex = confirmedScriptIndex + 1L;
        LinkedList<String> linkedList = this.scripts;
        synchronized (linkedList) {
            long remove;
            if (this.scriptsOffset < 0L || nextScriptIndex > this.scriptsOffset + (long)this.scripts.size()) {
                this.scriptsOffset = nextScriptIndex;
            }
            if ((remove = nextScriptIndex - this.scriptsOffset) > 0L) {
                for (long i = 0L; i < remove; ++i) {
                    this.scripts.removeFirst();
                }
                this.scriptsOffset = nextScriptIndex;
            }
        }
    }

    @Override
    public void setPage(String page) {
        this.page = page;
    }

    @Override
    public String getPage() {
        return this.page;
    }

    @Override
    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    @Override
    public String getWindowName() {
        return this.windowName;
    }

    @Override
    public void updateLastAccessedTime() {
        this.lastAccessedTime = System.currentTimeMillis();
        this.connectionValidationTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateIfNeeded() {
        if (this.invalidated) {
            return;
        }
        long now = System.currentTimeMillis();
        long age = now - this.lastAccessedTime;
        if (age > this.manager.getScriptSessionTimeout()) {
            Object object = this.sleeperLock;
            synchronized (object) {
                if (this.connectionValidationTime > 0L && now < this.connectionValidationTime) {
                    return;
                }
                if (this.connectionValidationTime == 0L && this.sleeper != null) {
                    int disconnectedTime = this.sleeper.wakeUpToClose();
                    this.connectionValidationTime = now + (long)disconnectedTime + (long)this.connectionValidationTimeout;
                    return;
                }
            }
            this.invalidate();
        }
    }

    public void setConnectionValidationTimeout(int connectionValidationTimeout) {
        this.connectionValidationTimeout = connectionValidationTimeout;
    }

    public int hashCode() {
        return 572 + this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        DefaultScriptSession that = (DefaultScriptSession)obj;
        return this.id.equals(that.id);
    }

    public String toString() {
        return "DefaultScriptSession[id=" + this.getDebugName() + "]";
    }

    protected String getDebugName() {
        int slashPos = this.id.indexOf(47);
        return this.id.substring(0, 4) + (slashPos >= 0 ? this.id.substring(slashPos, slashPos + 5) : "");
    }
}

