/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.directwebremoting.Container;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.event.ScriptSessionEvent;
import org.directwebremoting.event.ScriptSessionListener;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InitializingBean;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.UninitializingBean;
import org.directwebremoting.impl.DefaultScriptSession;
import org.directwebremoting.util.Loggers;

public class DefaultScriptSessionManager
implements ScriptSessionManager,
InitializingBean,
UninitializingBean {
    private long scriptSessionTimeout = 300000L;
    protected PageNormalizer pageNormalizer;
    protected long scriptSessionCheckTime = 30000L;
    protected ConverterManager converterManager = null;
    protected boolean jsonOutput = false;
    protected ScheduledThreadPoolExecutor executor;
    public static final String ATTRIBUTE_HTTPSESSIONID = "org.directwebremoting.ScriptSession.HttpSessionId";
    protected static final long DEFAULT_SESSION_CHECK_TIME = 30000L;
    protected List<ScriptSessionListener> scriptSessionListeners = new CopyOnWriteArrayList<ScriptSessionListener>();
    private volatile ScheduledFuture<?> future;
    protected volatile long lastSessionCheckAt = System.currentTimeMillis();
    protected final ConcurrentMap<String, DefaultScriptSession> sessionMap = new ConcurrentHashMap<String, DefaultScriptSession>();
    protected final ScriptSessionMultiMap sessionXRef = new ScriptSessionMultiMap("org.directwebremoting.ScriptSession.HttpSessionId");

    @Override
    public void afterContainerSetup(Container container) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DefaultScriptSessionManager.this.maybeCheckTimeouts();
            }
        };
        this.future = this.executor.scheduleWithFixedDelay(runnable, 60L, 60L, TimeUnit.SECONDS);
    }

    @Override
    public void contextDestroyed() {
    }

    @Override
    public void servletDestroyed() {
        this.future.cancel(true);
    }

    @Override
    public RealScriptSession getOrCreateScriptSession(String sentScriptId, String page, String httpSessionId) {
        DefaultScriptSession scriptSession;
        this.maybeCheckTimeouts();
        if ("".equals(sentScriptId)) {
            scriptSession = this.createScriptSession("", page);
            Loggers.SESSION.debug((Object)("Creating temporary script session on " + scriptSession.getPage()));
        } else {
            scriptSession = (DefaultScriptSession)this.sessionMap.get(sentScriptId);
            if (scriptSession == null) {
                scriptSession = this.createScriptSession(sentScriptId, page);
                Loggers.SESSION.debug((Object)("Creating " + scriptSession + " on " + scriptSession.getPage()));
                this.sessionMap.putIfAbsent(sentScriptId, scriptSession);
                this.fireScriptSessionCreatedEvent(scriptSession);
            } else {
                scriptSession.updateLastAccessedTime();
                String storedPage = scriptSession.getPage();
                if (!storedPage.equals(page)) {
                    scriptSession.setPage(page);
                }
            }
            this.associateScriptSessionAndHttpSession(scriptSession, httpSessionId);
        }
        return scriptSession;
    }

    protected DefaultScriptSession createScriptSession(String sentScriptId, String page) {
        return new DefaultScriptSession(sentScriptId, this, page, this.converterManager, this.jsonOutput);
    }

    protected void associateScriptSessionAndHttpSession(DefaultScriptSession scriptSession, String httpSessionId) {
        this.sessionXRef.associate(httpSessionId, scriptSession);
    }

    protected void disassociateScriptSessionAndHttpSession(DefaultScriptSession scriptSession) {
        this.sessionXRef.disassociate(scriptSession);
    }

    @Override
    public ScriptSession getScriptSessionById(String scriptSessionId) {
        return (ScriptSession)this.sessionMap.get(scriptSessionId);
    }

    @Override
    public Collection<ScriptSession> getScriptSessionsByHttpSessionId(String httpSessionId) {
        return this.sessionXRef.getByKey(httpSessionId);
    }

    @Override
    public Collection<ScriptSession> getAllScriptSessions() {
        HashSet<ScriptSession> reply = new HashSet<ScriptSession>();
        reply.addAll(this.sessionMap.values());
        return reply;
    }

    protected void invalidate(DefaultScriptSession scriptSession) {
        Loggers.SESSION.debug((Object)("Invalidating " + scriptSession + " from " + scriptSession.getPage()));
        this.sessionMap.remove(scriptSession.getId());
        this.disassociateScriptSessionAndHttpSession(scriptSession);
        this.fireScriptSessionDestroyedEvent(scriptSession);
    }

    protected void maybeCheckTimeouts() {
        long now = System.currentTimeMillis();
        if (now - this.scriptSessionCheckTime > this.lastSessionCheckAt) {
            this.checkTimeouts();
            this.lastSessionCheckAt = now;
        }
    }

    protected void checkTimeouts() {
        long now = System.currentTimeMillis();
        ArrayList<DefaultScriptSession> timeouts = new ArrayList<DefaultScriptSession>();
        for (DefaultScriptSession defaultScriptSession : this.sessionMap.values()) {
            long age;
            if (defaultScriptSession.isInvalidated() || (age = now - defaultScriptSession.getLastAccessedTime()) <= this.scriptSessionTimeout) continue;
            timeouts.add(defaultScriptSession);
        }
        for (ScriptSession scriptSession : timeouts) {
            DefaultScriptSession session = (DefaultScriptSession)scriptSession;
            session.invalidate();
        }
    }

    @Override
    public void addScriptSessionListener(ScriptSessionListener li) {
        this.scriptSessionListeners.add(li);
    }

    @Override
    public void removeScriptSessionListener(ScriptSessionListener li) {
        this.scriptSessionListeners.remove(li);
    }

    protected void fireScriptSessionCreatedEvent(ScriptSession scriptSession) {
        ScriptSessionEvent ev = null;
        for (int i = this.scriptSessionListeners.size() - 1; i >= 0; --i) {
            if (ev == null) {
                ev = new ScriptSessionEvent(scriptSession);
            }
            this.scriptSessionListeners.get(i).sessionCreated(ev);
        }
    }

    protected void fireScriptSessionDestroyedEvent(ScriptSession scriptSession) {
        ScriptSessionEvent ev = null;
        for (int i = this.scriptSessionListeners.size() - 1; i >= 0; --i) {
            if (ev == null) {
                ev = new ScriptSessionEvent(scriptSession);
            }
            this.scriptSessionListeners.get(i).sessionDestroyed(ev);
        }
    }

    @Override
    public String getInitCode() {
        return "dwr.engine._execute(dwr.engine._pathToDwrServlet, '__System', 'pageLoaded', [ function() { dwr.engine._ordered = false; }]);";
    }

    @Override
    public long getScriptSessionTimeout() {
        return this.scriptSessionTimeout;
    }

    public void setScriptSessionTimeout(long scriptSessionTimeout) {
        this.scriptSessionTimeout = scriptSessionTimeout;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionCheckTime(long scriptSessionCheckTime) {
        this.scriptSessionCheckTime = scriptSessionCheckTime;
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setJsonOutput(boolean jsonOutput) {
        this.jsonOutput = jsonOutput;
    }

    private class ScriptSessionMultiMap {
        private final ConcurrentMap<String, Set<String>> map = new ConcurrentHashMap<String, Set<String>>();
        private final String keyAttr;

        public ScriptSessionMultiMap(String keyAttr) {
            this.keyAttr = keyAttr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void associate(String key, ScriptSession scriptSession) {
            if (key == null) {
                return;
            }
            boolean done = false;
            do {
                HashSet<String> scriptSessionIds;
                if ((scriptSessionIds = (HashSet<String>)this.map.get(key)) == null) {
                    scriptSessionIds = new HashSet<String>();
                    this.map.putIfAbsent(key, scriptSessionIds);
                }
                HashSet<String> hashSet = scriptSessionIds;
                synchronized (hashSet) {
                    if (this.map.get(key) == scriptSessionIds) {
                        scriptSessionIds.add(scriptSession.getId());
                        scriptSession.setAttribute(this.keyAttr, key);
                        done = true;
                    }
                }
            } while (!done);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disassociate(ScriptSession scriptSession) {
            Object key = scriptSession.getAttribute(this.keyAttr);
            if (key == null) {
                return;
            }
            Set scriptSessionIds = (Set)this.map.get(key);
            if (scriptSessionIds == null) {
                Loggers.SESSION.debug((Object)"Warning: No script session ids for key");
                return;
            }
            if (!scriptSessionIds.contains(scriptSession.getId())) {
                Loggers.SESSION.debug((Object)"Warning: Script session already removed from key");
                return;
            }
            Set set = scriptSessionIds;
            synchronized (set) {
                scriptSessionIds.remove(scriptSession.getId());
                if (scriptSessionIds.size() == 0) {
                    this.map.remove(key);
                }
                scriptSession.setAttribute(this.keyAttr, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<ScriptSession> getByKey(String key) {
            ArrayList<ScriptSession> reply = new ArrayList<ScriptSession>();
            Set scriptSessionIds = (Set)this.map.get(key);
            if (scriptSessionIds != null) {
                Set set = scriptSessionIds;
                synchronized (set) {
                    for (String scriptSessionId : scriptSessionIds) {
                        DefaultScriptSession scriptSession = (DefaultScriptSession)DefaultScriptSessionManager.this.sessionMap.get(scriptSessionId);
                        if (scriptSession == null) continue;
                        reply.add(scriptSession);
                    }
                }
            }
            return reply;
        }
    }
}

