/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import org.directwebremoting.extend.IdGenerator;

public class DefaultSecureIdGenerator
implements IdGenerator {
    protected SecureRandom random = null;
    protected int countSinceSeed = 0;
    protected long seedTime = 0L;
    protected int countSinceTimeChange = 0;
    protected long lastGenTime = 0L;

    public DefaultSecureIdGenerator() {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (NoSuchAlgorithmException ex) {
        }
        catch (NoSuchProviderException ex) {
            // empty catch block
        }
        try {
            if (this.random == null) {
                this.random = SecureRandom.getInstance("SHA1PRNG");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.reseed();
    }

    @Override
    public synchronized String generate() {
        long time;
        long remainder;
        this.reseedIfNeeded();
        byte[] bytes = new byte[20];
        this.random.nextBytes(bytes);
        char[] charmap = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ*$".toCharArray();
        StringBuilder idbuf = new StringBuilder();
        for (byte b : bytes) {
            idbuf.append(charmap[b & 0x3F]);
        }
        for (remainder = time = System.currentTimeMillis(); remainder > 0L; remainder >>>= 6) {
            idbuf.append(charmap[(int)remainder & 0x3F]);
        }
        if (time == this.lastGenTime) {
            idbuf.append('-');
            for (remainder = (long)this.countSinceTimeChange; remainder > 0L; remainder >>>= 6) {
                idbuf.append(charmap[(int)remainder & 0x3F]);
            }
        } else {
            this.countSinceTimeChange = 0;
        }
        ++this.countSinceSeed;
        ++this.countSinceTimeChange;
        this.lastGenTime = time;
        return idbuf.toString();
    }

    protected void reseedIfNeeded() {
        boolean needReseed = false;
        long time = System.currentTimeMillis();
        if (time - this.seedTime > 900000L) {
            needReseed = true;
        }
        if (this.countSinceSeed > 1000) {
            needReseed = true;
        }
        if (needReseed) {
            this.reseed();
            this.seedTime = time;
            this.countSinceSeed = 0;
        }
    }

    protected void reseed() {
        this.random.setSeed(System.nanoTime());
    }
}

