/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.directwebremoting.Container;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.IdGenerator;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.RealWebContext;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.impl.DefaultServerContext;
import org.directwebremoting.util.SwallowingHttpServletResponse;

public class DefaultWebContext
extends DefaultServerContext
implements RealWebContext {
    private boolean avoidConnectionLimitWithWindowName = false;
    private RealScriptSession scriptSession;
    private String page;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    protected DefaultWebContext(Container container, HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig, ServletContext servletContext) {
        this.setServletConfig(servletConfig);
        this.setServletContext(servletContext);
        this.setContainer(container);
        this.request = request;
        this.response = response;
        Object value = container.getBean("avoidConnectionLimitWithWindowName");
        if (value != null) {
            this.avoidConnectionLimitWithWindowName = Boolean.parseBoolean(value.toString());
        }
    }

    @Override
    public void checkPageInformation(String sentPage, String sentScriptId, String windowName) {
        ScriptSessionManager scriptSessionManager = this.getScriptSessionManager();
        String httpSessionId = null;
        HttpSession httpSession = this.request.getSession(false);
        if (httpSession != null) {
            httpSessionId = httpSession.getId();
        }
        this.scriptSession = scriptSessionManager.getOrCreateScriptSession(sentScriptId, sentPage, httpSessionId);
        this.page = sentPage;
        if (this.avoidConnectionLimitWithWindowName) {
            if (windowName == null || "".equals(windowName)) {
                windowName = "DWR-" + this.getContainer().getBean(IdGenerator.class).generate();
                ScriptBuffer script = EnginePrivate.getRemoteHandleNewWindowNameScript(windowName);
                this.scriptSession.addScript(script);
            }
            this.scriptSession.setWindowName(windowName);
        }
    }

    @Override
    public String getCurrentPage() {
        if (this.page == null) {
            throw new UnsupportedOperationException("CurrentPage is not supported from a JSON call.");
        }
        return this.page;
    }

    @Override
    public ScriptSession getScriptSession() {
        return this.scriptSession;
    }

    @Override
    public HttpSession getSession() {
        return this.request.getSession();
    }

    @Override
    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return this.response;
    }

    @Override
    public String forwardToString(String url) throws ServletException, IOException {
        StringWriter sout = new StringWriter();
        StringBuffer buffer = sout.getBuffer();
        HttpServletResponse realResponse = this.getHttpServletResponse();
        SwallowingHttpServletResponse fakeResponse = new SwallowingHttpServletResponse(realResponse, sout, realResponse.getCharacterEncoding());
        HttpServletRequest realRequest = this.getHttpServletRequest();
        realRequest.setAttribute("org.directwebremoting", (Object)Boolean.TRUE);
        this.getServletContext().getRequestDispatcher(url).forward((ServletRequest)realRequest, (ServletResponse)fakeResponse);
        return buffer.toString();
    }

    private String simplifyId(String id) {
        if (id == null) {
            return "[null]";
        }
        if (id.length() == 0) {
            return "[blank]";
        }
        if (id.length() < 4) {
            return id;
        }
        return id.substring(0, 4);
    }

    @Override
    public String toString() {
        return "DefaultWebContext[id=" + this.simplifyId(this.scriptSession.getId()) + ", page=" + this.page + "]";
    }
}

