/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.extend.InitializingBean;
import org.directwebremoting.impl.PurgingDownloadManager;
import org.directwebremoting.io.FileTransfer;
import org.directwebremoting.io.InputStreamFactory;
import org.directwebremoting.io.OutputStreamLoader;
import org.directwebremoting.util.Base64;
import org.directwebremoting.util.LocalUtil;

public class FileStoreDownloadManager
extends PurgingDownloadManager
implements DownloadManager,
InitializingBean {
    private static final String FILE_PREFIX = "dwr";
    private static final String PART_SEPARATOR = ".";
    protected Object contentsLock = new Object();
    protected File downloadFileCache = null;
    private static final Log log = LogFactory.getLog(FileStoreDownloadManager.class);

    @Override
    public void afterContainerSetup(Container container) {
        if (this.downloadFileCache == null) {
            FileOutputStream out;
            File tempFile;
            block7: {
                tempFile = null;
                out = null;
                try {
                    tempFile = File.createTempFile("dwr-test", ".tmp");
                    out = new FileOutputStream(tempFile);
                    ((OutputStream)out).write("test".getBytes());
                    this.downloadFileCache = tempFile.getParentFile();
                    if (this.downloadFileCache != null) break block7;
                    throw new IllegalArgumentException("Temp files written to null directory");
                }
                catch (IOException ex) {
                    try {
                        throw new IllegalArgumentException("Temp directory provided by the JVM is not writable. See downloadFileCacheDir to customize.");
                    }
                    catch (Throwable throwable) {
                        LocalUtil.close(out);
                        if (tempFile != null) {
                            tempFile.delete();
                        }
                        throw throwable;
                    }
                }
            }
            LocalUtil.close(out);
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putFileTransfer(String id, FileTransfer transfer) {
        String filename = "dwr." + this.encodeFileNameSegment(id) + PART_SEPARATOR + this.encodeFileNameSegment(transfer.getMimeType()) + PART_SEPARATOR + this.encodeFileNameSegment(transfer.getFilename());
        FileOutputStream out = null;
        OutputStreamLoader loader = null;
        try {
            out = new FileOutputStream(new File(this.downloadFileCache, filename));
            loader = transfer.getOutputStreamLoader();
            loader.load(out);
        }
        catch (IOException ex) {
            try {
                log.error((Object)"Failed to write file to cache", (Throwable)ex);
            }
            catch (Throwable throwable) {
                LocalUtil.close(loader);
                LocalUtil.close(out);
                throw throwable;
            }
            LocalUtil.close(loader);
            LocalUtil.close(out);
        }
        LocalUtil.close(loader);
        LocalUtil.close(out);
    }

    @Override
    public FileTransfer getFileTransfer(String id) throws FileNotFoundException {
        final String prefix = "dwr." + this.encodeFileNameSegment(id) + PART_SEPARATOR;
        File[] match = this.downloadFileCache.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(prefix);
            }
        });
        if (match.length == 0) {
            return null;
        }
        if (match.length > 1) {
            log.warn((Object)("More than 1 match for prefix: " + prefix + ". Using first."));
        }
        File matched = match[0];
        String[] parts = matched.getName().split(Pattern.quote(PART_SEPARATOR), 4);
        String mimeType = this.decodeFileNameSegment(parts[2]);
        String filename = this.decodeFileNameSegment(parts[3]);
        final FileInputStream in = new FileInputStream(matched);
        return new FileTransfer(filename, mimeType, matched.length(), new InputStreamFactory(){

            @Override
            public InputStream getInputStream() throws IOException {
                return in;
            }

            @Override
            public void close() throws IOException {
                LocalUtil.close(in);
            }
        });
    }

    @Override
    protected void purge() {
        File[] match;
        final long now = System.currentTimeMillis();
        for (File file : match = this.downloadFileCache.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean nameMatch = file.getName().startsWith(FileStoreDownloadManager.FILE_PREFIX);
                boolean oldEnough = now > file.lastModified() + FileStoreDownloadManager.this.purgeDownloadsAfter;
                return nameMatch && oldEnough;
            }
        })) {
            file.delete();
        }
    }

    protected String encodeFileNameSegment(String segment) {
        String standardBase64 = new String(Base64.encodeBase64(segment.getBytes()));
        return standardBase64.replaceAll("+", "-").replaceAll("/", "_");
    }

    protected String decodeFileNameSegment(String segment) {
        String standardBase64 = segment.replaceAll("-", "+").replaceAll("_", "/");
        return new String(Base64.decodeBase64(standardBase64.getBytes()));
    }

    public void setDownloadFileCacheDir(String downloadFileCacheDir) {
        this.downloadFileCache = new File(downloadFileCacheDir);
        if (!this.downloadFileCache.exists()) {
            throw new IllegalArgumentException("Download cache does not exist: " + downloadFileCacheDir);
        }
        if (!this.downloadFileCache.isDirectory()) {
            throw new IllegalArgumentException("Download cache is not a directory: " + downloadFileCacheDir);
        }
    }
}

