/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.server.jetty;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.impl.BaseSleeper;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;

public class JettyContinuationSleeper
extends BaseSleeper {
    private final Continuation continuation;
    private final Object workLock = new Object();
    private boolean workInProgress = false;
    private boolean queuedWork = false;
    protected static final String ATTRIBUTE_SLEEPER = JettyContinuationSleeper.class.getName();

    public JettyContinuationSleeper(HttpServletRequest request, HttpServletResponse response, RealScriptSession scriptSession, ScriptConduit conduit) throws IOException {
        super(response, scriptSession, conduit);
        this.continuation = ContinuationSupport.getContinuation((ServletRequest)request);
    }

    @Override
    protected void enterSleep() {
        this.continuation.setAttribute(ATTRIBUTE_SLEEPER, (Object)this);
        this.continuation.setTimeout(0L);
        this.continuation.suspend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void wakeUp() {
        Object object = this.workLock;
        synchronized (object) {
            if (this.workInProgress) {
                this.queuedWork = true;
            } else {
                this.continuation.resume();
                this.workInProgress = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeWork() {
        while (true) {
            this.doWork();
            if (this.continuation.getAttribute(ATTRIBUTE_SLEEPER) == null) {
                return;
            }
            Object object = this.workLock;
            synchronized (object) {
                if (!this.queuedWork) {
                    this.continuation.suspend();
                    this.workInProgress = false;
                    return;
                }
                this.queuedWork = false;
            }
        }
    }

    @Override
    protected void close() {
        this.continuation.removeAttribute(ATTRIBUTE_SLEEPER);
    }

    public static JettyContinuationSleeper getSleeper(HttpServletRequest request) {
        return (JettyContinuationSleeper)request.getAttribute(ATTRIBUTE_SLEEPER);
    }
}

