/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.util.HashMap;
import java.util.Map;
import org.directwebremoting.extend.Remoter;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.servlet.FileJavaScriptHandler;
import org.directwebremoting.util.VersionUtil;

public class BaseEngineHandler
extends FileJavaScriptHandler {
    private String plainCallHandlerUrl;
    private String plainPollHandlerUrl;
    private String htmlCallHandlerUrl;
    private String htmlPollHandlerUrl;
    private ScriptSessionManager scriptSessionManager;
    private int maxWaitAfterWrite = -1;
    private boolean allowGetForSafariButMakeForgeryEasier = false;
    private String scriptTagProtection;
    private final boolean defaultToAsync = true;
    private Remoter remoter;
    private ServerLoadMonitor serverLoadMonitor;

    public BaseEngineHandler() {
        super("/org/directwebremoting/engine.js", "/org/directwebremoting/copyright.txt");
    }

    @Override
    protected Map<String, String> getSearchReplacePairs(String contextPath, String servletPath, String pathInfo) {
        HashMap<String, String> replace = new HashMap<String, String>();
        boolean streaming = true;
        if (this.maxWaitAfterWrite > -1 && this.maxWaitAfterWrite < 500) {
            streaming = false;
        }
        if (!this.serverLoadMonitor.supportsStreaming()) {
            streaming = false;
        }
        String useStreamingPoll = streaming ? "true" : "false";
        replace.put("${useStreamingPoll}", useStreamingPoll);
        replace.put("${contextPath}", contextPath);
        String contextServletPath = contextPath + servletPath;
        String pathToDwrServlet = this.remoter.getPathToDwrServlet(contextServletPath);
        replace.put("${pathToDwrServlet}", pathToDwrServlet);
        replace.put("${allowGetForSafariButMakeForgeryEasier}", String.valueOf(this.allowGetForSafariButMakeForgeryEasier));
        replace.put("${scriptTagProtection}", this.scriptTagProtection);
        replace.put("${plainCallHandlerUrl}", this.plainCallHandlerUrl);
        replace.put("${plainPollHandlerUrl}", this.plainPollHandlerUrl);
        replace.put("${htmlCallHandlerUrl}", this.htmlCallHandlerUrl);
        replace.put("${htmlPollHandlerUrl}", this.htmlPollHandlerUrl);
        replace.put("${defaultToAsync}", String.valueOf(true));
        replace.put("${versionMajor}", String.valueOf(VersionUtil.getMajor()));
        replace.put("${versionMinor}", String.valueOf(VersionUtil.getMinor()));
        replace.put("${versionRevision}", String.valueOf(VersionUtil.getRevision()));
        replace.put("${versionBuild}", String.valueOf(VersionUtil.getBuild()));
        replace.put("${versionTitle}", String.valueOf(VersionUtil.getTitle()));
        replace.put("${versionLabel}", String.valueOf(VersionUtil.getLabel()));
        replace.put("${initCode}", this.scriptSessionManager.getInitCode());
        replace.put("${debug}", String.valueOf(this.debug));
        return replace;
    }

    public void setServerLoadMonitor(ServerLoadMonitor serverLoadMonitor) {
        this.serverLoadMonitor = serverLoadMonitor;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }

    public void setScriptTagProtection(String scriptTagProtection) {
        this.scriptTagProtection = scriptTagProtection;
    }

    public void setMaxWaitAfterWrite(int maxWaitAfterWrite) {
        this.maxWaitAfterWrite = maxWaitAfterWrite;
    }

    public void setPlainCallHandlerUrl(String plainCallHandlerUrl) {
        this.plainCallHandlerUrl = plainCallHandlerUrl;
    }

    public void setPlainPollHandlerUrl(String plainPollHandlerUrl) {
        this.plainPollHandlerUrl = plainPollHandlerUrl;
    }

    public void setHtmlCallHandlerUrl(String htmlCallHandlerUrl) {
        this.htmlCallHandlerUrl = htmlCallHandlerUrl;
    }

    public void setHtmlPollHandlerUrl(String htmlPollHandlerUrl) {
        this.htmlPollHandlerUrl = htmlPollHandlerUrl;
    }

    public void setRemoter(Remoter remoter) {
        this.remoter = remoter;
    }

    public void setScriptSessionManager(ScriptSessionManager scriptSessionManager) {
        this.scriptSessionManager = scriptSessionManager;
    }
}

