/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.spring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.impl.StartupUtil;
import org.directwebremoting.servlet.UrlProcessor;
import org.directwebremoting.spring.SpringContainer;
import org.directwebremoting.util.FakeServletConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class DwrController
extends AbstractController
implements BeanNameAware,
InitializingBean,
DisposableBean,
BeanFactoryAware {
    private String name;
    private boolean debug = false;
    protected WebContextFactory.WebContextBuilder webContextBuilder;
    private SpringContainer container;
    private ServletConfig servletConfig;
    private boolean includeDefaultConfig = true;
    private List<Configurator> configurators;
    private Map<String, String> configParams = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog(DwrController.class);

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.container = new SpringContainer();
        this.container.setBeanFactory(beanFactory);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setConfigurators(List<Configurator> configurators) {
        this.configurators = configurators;
    }

    public void setIncludeDefaultConfig(boolean includeDefaultConfig) {
        this.includeDefaultConfig = includeDefaultConfig;
    }

    public void afterPropertiesSet() throws Exception {
        block11: {
            ApplicationContext parent = this.getApplicationContext().getParent();
            if (parent != null) {
                try {
                    Object parentConfigurator = parent.getBean("__dwrConfiguration");
                    if (parentConfigurator != null && !this.configurators.contains(parentConfigurator)) {
                        this.configurators.add((Configurator)parentConfigurator);
                    }
                }
                catch (RuntimeException rex) {
                    if (!log.isDebugEnabled()) break block11;
                    log.debug((Object)"Could not detect dwr configuration in parent context");
                }
            }
        }
        ServletContext servletContext = this.getServletContext();
        Assert.notNull((Object)servletContext, (String)"The servlet context has not been set on the controller");
        Assert.notNull(this.configurators, (String)"The required 'configurators' property should be set");
        this.configParams.put("debug", "" + this.debug);
        this.servletConfig = new FakeServletConfig(this.name, servletContext, this.configParams);
        try {
            StartupUtil.logStartup(((Object)((Object)this)).getClass().getSimpleName(), this.servletConfig);
            StartupUtil.setupDefaultContainer(this.container, this.servletConfig);
            this.webContextBuilder = this.container.getBean(WebContextFactory.WebContextBuilder.class);
            if (this.includeDefaultConfig) {
                StartupUtil.configureFromSystemDwrXml(this.container);
            }
            StartupUtil.configure(this.container, this.configurators);
        }
        catch (Exception ex) {
            log.fatal((Object)"init failed", (Throwable)ex);
            throw ex;
        }
        finally {
            if (this.webContextBuilder != null) {
                this.webContextBuilder.disengageThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.webContextBuilder.engageThread(this.container, request, response);
            UrlProcessor processor = this.container.getBean(UrlProcessor.class);
            processor.handle(request, response);
        }
        finally {
            this.webContextBuilder.disengageThread();
        }
        return null;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setConfigParams(Map<String, String> configParams) {
        Assert.notNull(configParams, (String)"configParams cannot be null");
        this.configParams = configParams;
    }

    public void destroy() throws Exception {
        this.container.servletDestroyed();
        this.container.contextDestroyed();
    }
}

