/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.LocalUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMConverter
extends BaseV20Converter
implements Converter {
    private final TransformerFactory xslFact = TransformerFactory.newInstance();
    private DocumentBuilderFactory buildFactory = null;

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data, InboundContext inctx) throws MarshallException {
        String value = LocalUtil.decode(data.getValue());
        try {
            if (this.buildFactory == null) {
                this.buildFactory = DocumentBuilderFactory.newInstance();
            }
            DocumentBuilder builder = this.buildFactory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(value));
            Document doc = builder.parse(is);
            if (paramType == Document.class) {
                return doc;
            }
            if (paramType == Element.class) {
                return doc.getDocumentElement();
            }
            throw new MarshallException(paramType);
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(paramType, (Throwable)ex);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        try {
            Transformer transformer = this.xslFact.newTransformer();
            if (!(data instanceof Node)) {
                throw new MarshallException(data.getClass());
            }
            Node node = (Node)data;
            DOMSource source = new DOMSource(node);
            StringWriter xml = new StringWriter();
            StreamResult result = new StreamResult(xml);
            transformer.transform(source, result);
            xml.flush();
            String script = EnginePrivate.xmlStringToJavascriptDom(xml.toString());
            NonNestedOutboundVariable ov = new NonNestedOutboundVariable(script);
            outctx.put(data, ov);
            return ov;
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(data.getClass(), (Throwable)ex);
        }
    }
}

