/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.Map;
import org.directwebremoting.dwrp.MapOutboundVariable;
import org.directwebremoting.dwrp.NonJsonNestedOutboundVariable;
import org.directwebremoting.dwrp.ObjectJsonOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectNonJsonOutboundVariable
extends NonJsonNestedOutboundVariable
implements MapOutboundVariable {
    private boolean isNamed;
    private Map<String, OutboundVariable> childMap;
    private String scriptClassName;

    public ObjectNonJsonOutboundVariable(OutboundContext outboundContext, String aScriptClassName) {
        super(outboundContext);
        this.scriptClassName = aScriptClassName;
        boolean bl = this.isNamed = this.scriptClassName != null && !"".equals(this.scriptClassName);
        if (this.isNamed) {
            this.forceOutline();
        }
    }

    @Override
    public void setChildren(Map<String, OutboundVariable> children) {
        this.setChildren(children.values());
        this.childMap = children;
    }

    @Override
    public void prepareAssignCode() {
        if (this.isOutline()) {
            this.setAssignCode(this.getVariableName());
        } else {
            this.prepareChildAssignCodes();
            this.setAssignCode(ObjectJsonOutboundVariable.createJsonString(this.childMap));
        }
    }

    @Override
    public void prepareBuildDeclareCodes() {
        if (this.isOutline()) {
            String variableName = this.getVariableName();
            String declareCode = !this.isNamed ? "var " + variableName + "={};" : "var " + variableName + "=new " + this.scriptClassName + "();";
            StringBuffer buildCode = new StringBuffer();
            for (Map.Entry<String, OutboundVariable> entry : this.childMap.entrySet()) {
                String name = entry.getKey();
                OutboundVariable nested = entry.getValue();
                String nestedAssignCode = nested.getAssignCode();
                if (LocalUtil.isSimpleName(name)) {
                    buildCode.append(variableName);
                    buildCode.append('.');
                    buildCode.append(name);
                    buildCode.append('=');
                    buildCode.append(nestedAssignCode);
                    buildCode.append(';');
                    continue;
                }
                buildCode.append(variableName);
                buildCode.append("['");
                buildCode.append(name);
                buildCode.append("']=");
                buildCode.append(nestedAssignCode);
                buildCode.append(';');
            }
            buildCode.append("\r\n");
            this.setBaseDeclareCode(declareCode);
            this.setBaseBuildCode(buildCode.toString());
        } else {
            this.setBaseDeclareCode("");
            this.setBaseBuildCode("");
        }
    }

    public String toString() {
        return "ObjectNonJsonOutboundVariable:" + this.childMap;
    }
}

